#include <string>
#include "mbed.h"

#pragma once

namespace ProjectOne{
    
    class Selection{
        public:
            /*
            * Constructor for Selection class.
            *
            @param The pins connected to the joystick on the application board.
            @return Nothing.
            */
            Selection(PinName Center=p14, PinName Up=p15, PinName Down=p12, PinName Left=p13, PinName Right=p16);
            
            /*
            * Method that prompts user to select the opperating mode.
            * Two modes available, slave and master.
            *
            @param Nothing.
            @return A string containing the selected mode.
            */
            string determineMode(void);
            
            /*
            * Method that prompts user to select the opperating id.
            * The id can have a value between 100 and 110.
            * Id is then passed to slave or master class according to operating mode.
            *
            @param Nothing.
            @return An int containing the selected id.
            */
            int determineId(void);
        
        private:
            BusIn joy;
    };
};