#pragma once

#include "mbed.h"

#define MAX_COMMAND_LENGTH 20

namespace ProjectOne{
 
    class Master{
        public:
            /*
            * Constructor for Master class.
            *
            @param The id for the master that is selected on boot.
            @return Nothing.
            */
            Master(int master_id);
            
            /*
            * Method that sends characters to serial connection on pc.
            *
            @param Characters that need to be displayed.
            @return Nothing.
            */
            void sendMessageToPc(char *thingsToDisplay);
            
            /*
            * Method that contains the master state-machine.
            * Waits for input from the user entered via a serial connection.
            * When command is entered, prompts user for slave id to send to.
            * Sends UDP packet to slave.
            * Waits for the response/acknowledgement from the slave.
            * Displays acknowledgement.
            *
            @param Char array containing the characters to display.
            @return Nothing.
            */
            void handlePcData(void);
            
        private:
            enum masterStates{
                STATE_INIT,
                STATE_RECEIVING_FROM_PC,
                STATE_HANDLE_ID,
                STATE_SEND_UDP_PACKET,
                STATE_HANDLE_RESPONSE,
                STATE_ERROR_STATE
            };
            
            masterStates CurrentMasterState;

            char inputCommandArray[512];
            char client_id[4];
            int char_counter_command, char_counter_id;
            
            int masterId;
            
            const static char *MASK;
            const static char *GATEWAY;
            
            Timer timer;
         
    };
 
};