#include "master.h"
#include "EthernetInterface.h"
#include <string.h>
#include <stdio.h>

#define MAX_PACKET_SIZE 512

namespace ProjectOne{
    
    Serial pc(USBTX, USBRX);
    
    const char* Master::MASK = "255.255.255.0";
    const char* Master::GATEWAY = "192.168.0.1";
    
    EthernetInterface eth_master;
    UDPSocket sock_master;
    Endpoint client;
     
    Master::Master(int master_id){
        masterId = master_id;
        CurrentMasterState = STATE_INIT;
    }

    void Master::handlePcData(void){
        char in_buffer[MAX_PACKET_SIZE];
        char client_ip[] =  {'1','9','2','.','1','6','8','.','0','.','x','x','x'};
        char ip_address[] = {'1','9','2','.','1','6','8','.','0','.','x','x','x'};
        switch(CurrentMasterState){
            case STATE_INIT:
            {
                //serial init
                pc.baud(9600);
                sendMessageToPc("-----------------");
                sendMessageToPc("Initiating master");
                sendMessageToPc("-----------------");
                
                int temp[3];
                int i = 0;
                do{
                   temp[i] = masterId % 10;
                   masterId /= 10;
                   i++; 
                }while(masterId !=0);
                
                char tempi[4];
                sprintf(tempi, "%ld", temp[2]);
                ip_address[10] = *tempi;
                sprintf(tempi, "%ld", temp[1]);
                ip_address[11] = *tempi;
                sprintf(tempi, "%ld", temp[0]);
                ip_address[12] = *tempi;

                eth_master.init(ip_address, MASK, GATEWAY);
                eth_master.connect();

                CurrentMasterState = STATE_RECEIVING_FROM_PC;
                break;
            }
            case STATE_RECEIVING_FROM_PC:
            {
                sendMessageToPc("Enter your command.");
                char temp1;
                memset(&inputCommandArray[0], 0, sizeof(inputCommandArray));
                char_counter_command = 0;
                for(int i = 0; i <= MAX_PACKET_SIZE; i ++){
                    temp1 = pc.getc();
                    if((int)temp1 == 13){
                        CurrentMasterState = STATE_HANDLE_ID;
                        break;
                    }
                    inputCommandArray[char_counter_command] = temp1;
                    char_counter_command++;
                }
                printf("The command you entered is: '%s'\r\n", inputCommandArray);
                CurrentMasterState = STATE_HANDLE_ID;  

                break;
            }
            case STATE_HANDLE_ID:
            {
                sendMessageToPc("Enter client ID:");
                char_counter_id = 0;
                char temp2;
                for(int i = 0; i <= 3; i ++){
                    temp2 = pc.getc();
                    if((int)temp2 == 13){
                        CurrentMasterState = STATE_SEND_UDP_PACKET;
                        break;
                    }
                    client_id[char_counter_id] = temp2;
                    char_counter_id++;
                }
                
                client_ip[10] = client_id[0];
                client_ip[11] = client_id[1];
                client_ip[12] = client_id[2];
                
                client_id[3] = '\0';
                
                client.set_address((const char *)client_ip,4000);

                CurrentMasterState = STATE_SEND_UDP_PACKET;
                break;
            }
            case STATE_SEND_UDP_PACKET:
            {
                sock_master.init();
                sock_master.sendTo(client, inputCommandArray, sizeof(inputCommandArray));
                memset(&inputCommandArray[0], 0, sizeof(inputCommandArray)); //clear input array
                CurrentMasterState = STATE_HANDLE_RESPONSE;
                break;
            }
            case STATE_HANDLE_RESPONSE:
            {
                memset(&in_buffer[0], 0, sizeof(in_buffer)); //buffer clear voor ontvangst
                int n = sock_master.receiveFrom(client, in_buffer, sizeof(in_buffer));
                sock_master.close();
                //stop timer, niet voltooid -> error state
                printf("Received response: '%s'\r\n", in_buffer);
                memset(&in_buffer[0], 0, sizeof(in_buffer)); //buffer clear na ontvangst
                CurrentMasterState = STATE_RECEIVING_FROM_PC;
                break;
            }
            case STATE_ERROR_STATE:
            {   
                sendMessageToPc("Error: did not receive a response from the client in time");
                memset(&in_buffer[0], 0, sizeof(in_buffer)); //buffer clear
                CurrentMasterState = STATE_RECEIVING_FROM_PC;
                break;
            }
        }
    }
    
    void Master::sendMessageToPc(char *message_to_pc){
        printf(message_to_pc);
        printf("\r\n");
    }
    
} 


    

   
    