#pragma once 

#include "mbed.h"
#include <string>

#define MAX_ARRAY_LENGTH 17

namespace ProjectOne{
        
    class BuzzerMusic{
        public:
            /*
            * Constructor for BuzzerMusic class.
            *
            @param pin that has a connection to the speaker on application board.
            @return Nothing.
            */
            BuzzerMusic(PinName speakerPin=p26);
            
            /*
            * Method that plays music when passed an index.
            *
            @param String that contains the x and y index (x-y).
            @return Nothing.
            */
            void playMusic(string indexes);
        private:
            const static int frequencies[MAX_ARRAY_LENGTH];
            const static int lengths[MAX_ARRAY_LENGTH];
            const static int delays[MAX_ARRAY_LENGTH];
            PwmOut speaker;
    };

};