#include "selection.h"
#include "mbed.h"

#pragma once


namespace ProjectOne{
    
    Selection::Selection(PinName firstPin, PinName secondPin, PinName thirdPin, PinName fourthPin, PinName fifthPin)  : joy(firstPin,secondPin,thirdPin,fourthPin,fifthPin)
    {

    }
    
    string Selection::determineMode(void){
        printf("Select desired operating mode\r\n");
        printf("Confirm by pressing down joystick\r\n");
        printf("Up = master, Down = slave\r\n");
        string selected_mode = "";
        while(joy.read() != 1){
            if(joy.read() == 2){
                selected_mode = "master";
                printf("Current mode is: '%s'\r\n", selected_mode.c_str());
            }
            if(joy.read()  == 4){
                selected_mode = "slave";
                printf("Current mode is: '%s'\r\n", selected_mode.c_str());
            }
            wait(0.5);
        }
        if(joy.read() == 1){
            return selected_mode;
        }
    }
    
    int Selection::determineId(void){
        wait(1);
        int selected_id = 100;
        printf("Select desired id, range: 100-110, standard = 100\r\n");
        printf("Left = decrease, Right = increase\r\n");
        while(joy.read() != 1){
            if(joy.read()  == 8){
                if(selected_id <= 110 && selected_id > 100){
                    selected_id--;
                    printf("Current id is: '%d'\r\n", selected_id);
                } 
            }
            if(joy.read()  == 16){
                if(selected_id >= 100 && selected_id < 110){
                    selected_id++;
                    printf("Current id is: '%d'\r\n", selected_id);
                }
            }
            wait(0.5);
        }
        if(joy.read() == 1){
            return selected_id;
        } 
    }
    
}