#include "i2c_qt1070.h"
extern "C" void mbed_reset();

namespace I2cQt1070Device{
    I2cQt1070::I2cQt1070(PinName sda, PinName scl, int address, int frequency)
    : I2CSlave(sda, scl){
        
        this->address(address);
        this->frequency(frequency);
    }
    
    void I2cQt1070::check_for_instruction(void){
        int addressed = receive(); 
        switch (addressed) {
            case I2CSlave::WriteAddressed:{
                printf("Write addressedd\r\n");
                process_write_request();
                break;
            }   
            case I2CSlave::ReadAddressed:{
                printf("Read addressedd\r\n");
                send_register_to_master();
                break;
            }   
        }
    }
    
    void I2cQt1070::send_register_to_master(void){ 
        switch(qt1070Address){
            case READ_ID:{
                printf("Received id command\r\n");
                char id = qt1070.getId();
                char buffer[1];
                buffer[0] = id;
                write(buffer,1);
                break;
            } 
            case READ_FIRMWARE:{
                printf("Received firmware command\r\n");
                char version = qt1070.getFirmware();  
                char buffer[1];
                buffer[0] = version;
                write(buffer,1);     
                break;
            }
            case READ_KEY_STATUS:{
                printf("Received key status command\r\n");
                char status = qt1070.getStatus();
                char buffer[1];
                buffer[0] = status;
                write(buffer,1);
                break;
            }
            
            case RESET:{
                printf("Received reset command\r\n");
                mbed_reset();
                stop();
                break;
            }
            default:{
                printf("Unknown command byte recieved from master\r\n");
            }
        }  
    }

    int I2cQt1070::process_write_request(void){
        char nextQt1070Address = this->read();
            this->qt1070Address = nextQt1070Address;
        this->stop();
    }

};