#pragma once
#include "qt1070.h"
#include "mbed.h"

namespace I2cQt1070Device{
    
   enum I2cInstruction{
        READ_ID = 0, //adres 0x00
        READ_FIRMWARE = 1, //adres 0x01
        READ_KEY_STATUS  = 3,  //adres 0x03
        RESET = 57//0x57  
    };
    
    class I2cQt1070: public I2CSlave{
        
        private:
            Qt1070 qt1070;
            char qt1070Address;
            void send_register_to_master(void);
            int process_write_request(void);
            
        public:
            I2cQt1070(PinName sda, PinName scl, int address=0x36, int frequency=100000);
            void check_for_instruction(void);

    };
    
};