#include "mbed.h"
#include "SRF02.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"

SRF02 sensor (0xE0, PB_9, PB_8);
Serial LCD(USBTX, USBRX);

int main() {
    LCD.baud(115200);
    int distance = sensor.GetCentimeters();
    LCD.printf("Distance = %d cm\n",distance);
    wait(1);
    
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t text[30];
    uint8_t status;
    uint8_t idx;
    uint8_t cleared;
    uint8_t prev_nb_touches = 1;
    
    int old_val=0;
    int new_val=0;
    
    // Initialisation du LCD intégrée dans le STM32F746G
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    BSP_LCD_Clear(LCD_COLOR_BLACK);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
    BSP_LCD_SetFont(&LCD_DEFAULT_FONT);
    BSP_LCD_DisplayStringAt(0, 1, (uint8_t *)"Capteur SRF02 distance", CENTER_MODE);
    BSP_LCD_SetTextColor(LCD_COLOR_RED);
    BSP_LCD_DisplayStringAt(0, 65, (uint8_t *)"en centimetre", CENTER_MODE);
    BSP_LCD_SetTextColor(LCD_COLOR_RED);
    BSP_LCD_DisplayStringAt(0, 30, (uint8_t *)"Avec obstacle", CENTER_MODE);
    
    HAL_Delay(1000);
    
    status = BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize());
    if (status != TS_OK) {
        BSP_LCD_Clear(LCD_COLOR_BLACK);
        BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"ALARM NON ACTIVE", CENTER_MODE);
        }
        
        else {
        BSP_LCD_Clear(LCD_COLOR_BLUE);
        BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"ALARM ACTIVE", CENTER_MODE);
        }
        
        HAL_Delay(1000);
        
        
        while(1) {
            BSP_LCD_Clear(LCD_COLOR_BLUE);
            int distance = sensor.GetCentimeters();
            old_val = new_val;
            new_val = distance;
            
            if(new_val - old_val >= 5) BSP_LCD_DisplayStringAt(0, LINE(1), (uint8_t *)"Detecte", CENTER_MODE);
            sprintf((char*)text, "distance %d cm", distance);
            BSP_LCD_DisplayStringAt(0, LINE(0), (uint8_t *)&text, CENTER_MODE);
            BSP_LCD_DrawRect( distance*2, 100, 30,50);
            BSP_LCD_FillRect( distance*2, 100, 30,50);
            HAL_Delay(5000);
            }
    }


  