/* Includes */
#include "mbed.h"
#include "XNucleoIKS01A2.h"
#include "SDFileSystem.h"
#include "FATFileSystem.h"
#include "iostream"

Serial pc(USBTX, USBRX, 115200);
Serial gps(D8, D2, 9800);

SDFileSystem sd(D11, D12, D13, D10, "sd");// the pinout on the mbed Cool Components workshop board
FILE *fp;

/* Instantiate the expansion board */
static XNucleoIKS01A2 *mems_expansion_board = XNucleoIKS01A2::instance(D14, D15, D4, D5);

/* Retrieve the composing elements of the expansion board */
static LSM6DSLSensor *acc_gyro = mems_expansion_board->acc_gyro;
static LSM303AGRAccSensor *accelerometer = mems_expansion_board->accelerometer;

DigitalIn userButton(PC_13); //USER BUTTON
bool live_writing = false;

// GPS
char cDataBuffer[500];
int i = 0;
char c;
void parse(char *cmd, int n){
    char ns, ew, tf, status;
    int fq, nst, fix, date; // fix quality, Number of satellites being tracked, 3D fix
    float latitude, longitude, timefix, speed, altitude;
        
    // Global Positioning System Fix Data
    if(strncmp(cmd,"$GPGGA", 6) == 0){
        sscanf(cmd, "$GPGGA,%f,%f,%c,%f,%c,%d,%d,%*f,%f", &timefix, &latitude, &ns, &longitude, &ew, &fq, &nst, &altitude);
        printf("GPGGA Fix taken at: %f, Latitude: %f %c, Longitude: %f %c, Fix quality: %d, Number of sat: %d, Altitude: %f M\r\n", timefix, latitude, ns, longitude, ew, fq, nst, altitude);
    }
    
    // Satellite status
    if(strncmp(cmd,"$GPGSA", 6) == 0){
        sscanf(cmd, "$GPGSA,%c,%d,%d", &tf, &fix, &nst);
        printf("GPGSA Type fix: %c, 3D fix: %d, number of sat: %d\r\n", tf, fix, nst);
    }
    
    // Geographic position, Latitude and Longitude
    if(strncmp(cmd,"$GPGLL", 6) == 0){
        sscanf(cmd, "$GPGLL,%f,%c,%f,%c,%f", &latitude, &ns, &longitude, &ew, &timefix);
        printf("GPGLL Latitude: %f %c, Longitude: %f %c, Fix taken at: %f\r\n", latitude, ns, longitude, ew, timefix);
    }
    
    // Geographic position, Latitude and Longitude
    if(strncmp(cmd,"$GPRMC", 6) == 0){
        sscanf(cmd, "$GPRMC,%f,%c,%f,%c,%f,%c,%f,,%d", &timefix, &status, &latitude, &ns, &longitude, &ew, &speed, &date);
        printf("GPRMC Fix taken at: %f, Status: %c, Latitude: %f %c, Longitude: %f %c, Speed: %f, Date: %d\r\n", timefix, status, latitude, ns, longitude, ew, speed, date);
    }
}

/* Simple main function */
int main() {
  uint8_t id;
  int32_t x_axes[3];
  int32_t g_axes[3];
  float x_freq[2];
  float g_freq[2];
  float x_sens[2];
  float x_fs[2];
  // Take time (https://unixtime.org/)
  set_time(1635956827);
  
  // DATE
  char s[100];
  time_t t_l      = time (NULL);
  struct tm *tp = localtime (&t_l);
  strftime (s,100, "\n\t %d %B %Y %H:%M:%S\r\n", tp);
  printf ("%s", s);
  
  /* Enable all sensors */
  accelerometer->enable(); //Data from LSM303AGR
  acc_gyro->enable_x(); //Data from LSM6DSL
  acc_gyro->enable_g(); //Data from LSM6DSL
  
  printf("\r\n--- Starting new run ---\r\n");

  accelerometer->read_id(&id);
  printf("LSM303AGR accelerometer           = 0x%X\r\n", id);
  acc_gyro->read_id(&id);
  printf("LSM6DSL accelerometer & gyroscope = 0x%X\r\n", id);

 int n=0;
 int arr_lenght = 500;

 Timer t;
 Timer t_down;
 float time[arr_lenght];
 int acc_x[arr_lenght];
 int acc_y[arr_lenght];
 int acc_z[arr_lenght];
 int gyro_x[arr_lenght];
 int gyro_y[arr_lenght];
 int gyro_z[arr_lenght];
 float frequency = 1000.0;
 float range = 8.0;
 //SET
 acc_gyro->set_x_odr(frequency);
 acc_gyro->set_g_odr(frequency);
 acc_gyro->set_x_fs(range);
 //GET
 acc_gyro->get_x_odr(x_freq);
 printf("Accelerometer frequency: %.1f, %.1f\r\n", x_freq[0],x_freq[1]);
 acc_gyro->get_g_odr(g_freq);
 printf("Gryroscope frequency: %.1f, %.1f\r\n", g_freq[0],g_freq[1]);
 acc_gyro->get_x_sensitivity(x_sens);
 printf("Accelerometer sensitivity: %.3f, %.1f\r\n", x_sens[0],x_sens[1]);
 acc_gyro->get_x_fs(x_fs);
 printf("Accelerometer meas. range: %.1f, %.1f\r\n", x_fs[0],x_fs[1]);
 
 printf("Check GPS\r\n");
 while(1){
        if(gps.readable()){
            if(gps.getc() == '$');{           // wait a $
                for(int i=0; i<sizeof(cDataBuffer); i++){
                    c = gps.getc();
                    if( c == '\r' ){
                        parse(cDataBuffer, i);
                        i = sizeof(cDataBuffer);
                    }else{
                        cDataBuffer[i] = c;
                    }                 
                }
            }
         }
         if(!userButton){
             break;
         }
 }

 printf("OK\r\n");
 printf("\r\n");
  /* Start the cycle*/
 while(true){ //run forever
     if (!userButton) {  // button is pressed
        if  (live_writing==false) {
            live_writing = true;
            n = 0;
            //Initialize SD CARD
            char filename[64];
            char date[64];
            printf("Check SD\r\n");
            mkdir("/sd/ISK01A2", 0777);
            int name = 0;
            // Save name with next name test_001,test_002, ecc...
            while(1) {
                sprintf(filename, "/sd/ISK01A2/test_%03d.txt", name);    
                FILE *fp = fopen(filename, "r");
                if(fp == NULL) {
                break;
                }
            fclose(fp);
            name++;
            }
        
            fp = fopen(filename, "w");
            if (fp == NULL) {
                error("Unable to write the file\r\n");
            }
            
            // Name file on monitor
            printf("\n\t test_%03d \r\n", name);
            strftime (date,64, "%d %B %Y %H:%M", tp);
            fprintf(fp, "\t %s \n", date); //DATE
            fprintf(fp, "N,Time,Temp[C],Acc_x[mg],Acc_y[mg],Acc_z[mg],Gyro_x[mdps],Gyro_y[mdps],Gyro_z[mdps]\r\n"); //Header in the file text
            
            printf("\r\n START NEW RUNNING \r\n");
            t.start();
            } else { // button is pressed but live_writing is true
                        
            // Now we write into sd card all data storaged
            t.stop();
            int i;
            //int elementi = sizeof(acc_x)/sizeof(int);
            
            for (i=0; i<=n; i++){                 
                 fprintf(fp,"%3d,%3.3f,%6ld,%6ld,%6ld,%6ld,%6ld,%6ld\r\n", i, time[i], acc_x[i], acc_y[i], acc_z[i], gyro_x[i], gyro_y[i], gyro_z[i]); //Save current data into file txt
                 //printf("%3d,%3.3f,%6ld,%6ld,%6ld,%6ld,%6ld,%6ld\r\n", i, time[i], acc_x[i], acc_y[i], acc_z[i], gyro_x[i], gyro_y[i], gyro_z[i]);
            }
            t.reset();
            fclose(fp);
            printf("File successfully written!\r\n");
            live_writing = false;
            wait(2);
            }//end else
     } //end if userbutton
    if (live_writing==true){ 
            acc_gyro->get_x_axes(x_axes); //Read data from LSM6DSL accelerometer
            acc_x[n] = x_axes[0];
            acc_y[n] = x_axes[1];
            acc_z[n] = x_axes[2];
            
            acc_gyro->get_g_axes(g_axes); //Read data from LSM6DSL gyroscope
            gyro_x[n] = g_axes[0];
            gyro_y[n] = g_axes[1];
            gyro_z[n] = g_axes[2];
            
            time[n] = t.read();
            n+=1;
            
            if (n==arr_lenght){
                t.stop();
                int i;
                
                for (i=0; i<=n; i++){
                     fprintf(fp,"%3d,%3.3f,%6ld,%6ld,%6ld,%6ld,%6ld,%6ld\r\n", i, time[i], acc_x[i], acc_y[i], acc_z[i], gyro_x[i], gyro_y[i], gyro_z[i]); //Save current data into file txt
                     //printf("%3d,%3.3f,%6ld,%6ld,%6ld,%6ld,%6ld,%6ld\r\n", i, time[i], acc_x[i], acc_y[i], acc_z[i], gyro_x[i], gyro_y[i], gyro_z[i]);                     
                }
                t.reset();
                fclose(fp);
                printf("File successfully written!\r\n");
                live_writing = false;
                wait(2);
                }
            }//end while writing
    }//end while
}//end main

