#include "ADXL.h"

SPI acc(p11, p12, p13);
DigitalOut cs(p10);
char buffer[6];
int16_t tempData[3];
float x, y, z;

void accConfig() {
    cs=1;                   // initially ADXL345 is not activated
    acc.format(8,3);        // 8 bit data, Mode 3
    acc.frequency(2000000); // 2MHz clock rate
    cs=0;                   //select the device
    acc.write(0x31);        // data format register
    acc.write(0x0B);        // format +/-16g, 0.004g/LSB
    cs=1;                   //end of transmission
    cs=0;                   //start a new transmission
    acc.write(0x2D);        // power ctrl register
    acc.write(0x08);        // measure mode
    cs=1;                   // end of transmission
}

void getAccel(float* data) {
        wait(0.2);
        cs=0;                           //start a transmission
        acc.write(0x80|0x40|0x32);      // RW bit high, MB bit high, plus address
        for (int i = 0;i<=5;i++) {
            buffer[i]=acc.write(0x00);  // read back 6 data bytes
        }
        cs=1;                           //end of transmission
        tempData[0] = buffer[1] << 8 | buffer[0]; //combine MSB and LSB
        tempData[1] = buffer[3] << 8 | buffer[2];
        tempData[2] = buffer[5] << 8 | buffer[4];
        x = tempData[0]*0.004;
        y = tempData[1]*0.004;
        z = tempData[2]*0.004;
        data[0] = x;
        data[1] = y;
        data[2] = z;
        
}