#include "mbed.h"
#include "ADXL.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "ILI932x.h"

Serial pc(USBTX, USBRX);
float data[6];
PinName dataBus[]= {p30, p29, p28, p27, p26, p25, p24, p23};
ILI932x myLCD(BUS_8, dataBus, p15, p17, p16, p14, p20, "myLCD", 240, 320); // Bus 8 bit, bus pin array, CS, RST, DC, WR, RD, name, xpixels, ypixels
char orient=4;
int X = 120, Y = 160, oldY, oldX;

int main() {
    accConfig();
    myLCD.set_orientation(orient);
    //t.start();
    myLCD.set_font((unsigned char*) Arial12x12);
    myLCD.background(Black);    // set background to red
    myLCD.foreground(White);    // set chars to black
    myLCD.cls();                // clear the screen
    /*
    myLCD.locate((myLCD.width()-7)/2,myLCD.height()/2);        // from our view, first is yPos, second is xPos
    myLCD.printf("Target Practice\r\n");
    wait(2);
    myLCD.cls();
    */
    wait(1);
    myLCD.circle(120,160,12,White);
    while(1) {
        //temporary code:
        myLCD.fillcircle(oldX,oldY,6,Black);
        myLCD.fillcircle(X,Y,6,Blue);
        oldX = X;
        oldY = Y;        
        getAccel(data);
        pc.printf("x = %1.2fg\t y = %1.2fg\t z = %1.2fg \n\r", data[0], data[1], data[2]); //print
        if (((X + data[0]) < myLCD.width()-10) && (X + data[0]) > 10)
            X += data[0]*30;
        if ((Y + data[1]) < myLCD.height()-10 && (Y + data[1]) > 10)
            Y -= data[1]*30;
        wait(0.002);
        
        //insert correct code here:
        
    }
}
