#ifndef STATES_TRANSFORM_H
#define STATES_TRANSFORM_H
//
#include <vector>
using std::vector;

class TRANSFORM_MOTOR_separate_2_avgDelta{
public:
    // Parameters
    vector<float> states_R_L; // [R;L]
    vector<float> states_avg_delta; // [avg;delta], avg = (R+L)/2, delta = (R-L)

    TRANSFORM_MOTOR_separate_2_avgDelta(void);
    // Method for assignment with automatic transformation
    void assign_R_L(float R_in, float L_in); // Assign states_R_L
    void assign_R_L(const vector<float> &states_R_L_in); // Assign states_R_L
    void assign_avg_delta(float avg_in, float delta_in); // Assign states_avg_delta
    void assign_avg_delta(const vector<float> &states_avg_delta_in); // Assign states_avg_delta
    // Get elements
    float get_R(void);
    float get_L(void);
    float get_avg(void);
    float get_delta(void);

private:
    void transform(void); // avg = (R+L)/2, delta = (R-L)
    void transform_inv(void); // R = avg + 0.5*delta, L = avg - 0.5*delta
};

#endif
