#include "STATES_TRANSFORM.h"

TRANSFORM_MOTOR_separate_2_avgDelta::TRANSFORM_MOTOR_separate_2_avgDelta(void){
    states_R_L.assign(2,0.0);
    states_avg_delta.assign(2,0.0);
}
//
void TRANSFORM_MOTOR_separate_2_avgDelta::assign_R_L(float R_in, float L_in){ // Assign states_R_L
    states_R_L[0] = R_in;
    states_R_L[1] = L_in;
    //
    transform();
}
void TRANSFORM_MOTOR_separate_2_avgDelta::assign_R_L(const vector<float> &states_R_L_in){ // Assign states_R_L
    states_R_L = states_R_L_in;
    //
    transform();
}
void TRANSFORM_MOTOR_separate_2_avgDelta::assign_avg_delta(float avg_in, float delta_in){ // Assign states_avg_delta
    states_avg_delta[0] = avg_in;
    states_avg_delta[1] = delta_in;
    //
    transform_inv();
}
void TRANSFORM_MOTOR_separate_2_avgDelta::assign_avg_delta(const vector<float> &states_avg_delta_in){ // Assign states_avg_delta
    states_avg_delta = states_avg_delta_in;
    //
    transform_inv();
}
//
float TRANSFORM_MOTOR_separate_2_avgDelta::get_R(void){
    return states_R_L[0];
}
float TRANSFORM_MOTOR_separate_2_avgDelta::get_L(void){
    return states_R_L[1];
}
float TRANSFORM_MOTOR_separate_2_avgDelta::get_avg(void){
    return states_avg_delta[0];
}
float TRANSFORM_MOTOR_separate_2_avgDelta::get_delta(void){
    return states_avg_delta[1];
}

//
void TRANSFORM_MOTOR_separate_2_avgDelta::transform(void){
    states_avg_delta[0] = 0.5*(states_R_L[0] + states_R_L[1]);
    states_avg_delta[1] = states_R_L[0] - states_R_L[1];
}
void TRANSFORM_MOTOR_separate_2_avgDelta::transform_inv(void){
    states_R_L[0] = states_avg_delta[0] + 0.5*states_avg_delta[1];
    states_R_L[1] = states_avg_delta[0] - 0.5*states_avg_delta[1];
}
