#ifndef PID_H
#define PID_H

#include "mbed.h"

class PID{
    public:

        PID(float Kp_in, float Ki_in, float Kd_in,  float Sampletime_in);
        void Compute(float reference_in, float feedbackvalue_in);
        void Reset(void);
        //
        void Compute_noWindUP(float reference_in, float feedbackvalue_in);
        // Method 1: Separated operation for anti-windup
        void Saturation_output();
        void Anti_windup(float delta); // delta_V = Vs - V
        // Method 2: Single anti-windup operation
        void Anti_windup();
        //

        void SetOutputLimits(float setoutputLimits_H, float setoutputLimits_L);
        void SetInputLimits(float setinputLimits_H, float setinputLimits_L);
        void EnableAntiWindUp(float Ka_in);

        float Kp;
        float Ki;
        float Kd;
        float Ka;

        float error[2];
        double error_I;

        float output;
        float reference;
        float delta_output; // Error by saturating

        float Ts;

    private:

        bool Outputlimit_bool;
        bool Inputlimit_bool;
        bool AntiWindUp_bool;

        float outputLimits_H;
        float outputLimits_L;
        float inputLimits_H;
        float inputLimits_L;

        float feedbackvalue;
 //       Ticker PID_timer;

};

#endif /* PID_H*/
