#ifndef PID_H
#define PID_H
//
#include "FILTER_LIB.h"

class PID{
public:

    // Sampling time
    float Ts;
    //
    bool enable;

    // Flags
    bool is_limiting_command;
    bool is_limiting_output;
    //
    bool is_using_integral; // Determine if the integral control is going to be used.
    bool is_using_derivative; // Determine if the derivative control is going to be used.
    //
    bool is_using_outSource_d_error; // Determine whether using the signal for d_error or using numerical derivative to derive d_error from error.
    //
    bool is_antiWindUp;

    // Parameters
    // Feedback gain
    float Kp;
    float Ki;
    float Kd;
    //
    // float Ka;

    // States
    float error;
    float d_error;
    float error_int;
    //
    float error_int_increment; // error_int += error_int_increment;

    // Input signal
    float command;
    float feedbackValue;
    // Output signal
    float output;
    // Error by saturation
    float delta_output; // Error by saturation


    PID(float Kp_in, float Ki_in, float Kd_in,  float Sampletime_in);
    // Process controller
    void start(); // Run
    void pause(); // Stop updating but no reset
    void stop(); // Stop and reset
    void reset(); // Reset all the states to initial values.
    //
    void EnableAntiWindUp(float Ka_in);
    //
    void set_PID_gains(float Kp_in, float Ki_in, float Kd_in); // Setting Kp, Ki, and Kd
    void SetInputLimits(float inputLimits_H_in, float inputLimits_L_in);
    void SetOutputLimits(float outputLimits_H_in, float outputLimits_L_in);

    // Main function for computing the PID
    void set_d_error(float d_error_in); // Insert d_error before iteration.
    void iterateOnce(float command_in, float feedbackValue_in);
    void iterateOnce_noAntiWindUP(float command_in, float feedbackValue_in);

    // Anti-windup method
    // Method 1: Separated operation for anti-windup
    void Saturation_output();
    void AntiWindUp(float delta); // delta_V = V - V_sat
    // Method 2: Single anti-windup operation
    void Saturation_AntiWindUp();
    //

private:

    // Derivative
    Derivative_appr derivative_error;

    // Saturation
    Saturation SAT_command;
    Saturation SAT_output;

    // Small over-bound value for numerical stability
    float overBound_value; // Small positive value

};

#endif /* PID_H*/
