#include "LCD.h"
#include "BMP280.h"
#include "SDBlockDevice.h"
#include "FATFileSystem.h"

#define ENTER_KEY 1
#define MAX_SAMPLES 120
#define SENSOR_UPDATE 1
#define DATA_READY 1
#define LCD_REFRESH 1  // define time for LCD to refresh (ever 1 second for clock)
#define LCD_READY 1         // LCD ISR to LCD thread Signal
#define ON 1
#define OFF 0

#if !FEATURE_LWIP
    #error [NOT_SUPPORTED] LWIP not supported for this target
#endif

#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPServer.h"
#include "TCPSocket.h"
#include <iostream>
#include <string> 

#define HTTP_STATUS_LINE "HTTP/1.0 200 OK"
#define HTTP_HEADER_FIELDS "Content-Type: text/html; charset=utf-8"
#define HTTP_MESSAGE_BODY1 ""                                    \
"<html>" "\r\n"                                                  \
"  <body style=\"display:flex;text-align:center\">" "\r\n"       \
"   <meta http-equiv=\"refresh\" content=\"1; \"\> " "\r\n"        \
"    <div style=\"margin:auto\">" "\r\n"                         \
"      <h1>Sensor Data</h1>" "\r\n"                              \
"      <p> Date/Time: "                                                \

#define HTTP_MESSAGE_BODY2 ""                                    \
       "</p>" "\r\n"                                             \
"    </div>" "\r\n"                                              \
"  </body>" "\r\n"                                               \
"</html>"

#define HTTP_RESPONSE HTTP_STATUS_LINE "\r\n"   \
                      HTTP_HEADER_FIELDS "\r\n" \
                      "\r\n"                    \
                      HTTP_MESSAGE_BODY "\r\n"

#define IP        "10.0.0.10"
#define NETMASK   "255.0.0.0"
#define GATEWAY   "10.0.0.1"


extern LCD lcd;
extern BMP280 sensor;
extern SDBlockDevice sd (PB_5, D12, D13, D10);

/* External LEDs as Open Drain */
extern DigitalOut Red_ext      (PE_15); 
extern DigitalOut Yellow_ext   (PB_10);
extern DigitalOut Green_ext    (PB_11);

/* Configure On-board LEDS */
extern DigitalOut Green_int (LED1);
extern DigitalOut Blue_int (LED2);
extern DigitalOut Red_int (LED3);

/* Configure Digital In Switches */
extern DigitalIn SW_L (PE_12);
extern DigitalIn SW_R (PE_14);
extern DigitalIn sdIn (PE_10);
//extern DigitalIn SW_B (USER_BUTTON); //defined as interrupt now for SD
/* Configure Analogue Pins  */
/* Analogue IN */
extern AnalogIn LDR_In (PA_0);

/* Congfigure Serial interface */
Serial pc(USBTX, USBRX);

/* Mail */
typedef struct {
    int Time_Date;
    float LDR_Value;
    float temp_Value;
    float press_Value;
} mail_t;

Mail<mail_t, 16> mail_LCD;
Mail<mail_t, 16> mail_FIFO;
Mail<mail_t, 16> mail_Network;
//Mail<mail_t, 16> mail_box2;

//data FIFO buffer
char data_buffer[MAX_SAMPLES][64];
int sample_h = 0;
int sample_t = 0;
int data_h = 0;
int data_t = 0;
struct tm * sample_epoch;


//Serial_CMD
volatile int rx_in=0;
char rx_buffer[32];
time_t raw_time = time(NULL);
char serial_buffer[80];

extern void POST();
