#ifndef MBED_LCD_H
#define MBED_LCD_H


#define CMD          0
#define TXT          1
#define CLEAR        1
#define HOME         2
#define READ         1
#define WRITE        0
#define LEFT         0
#define RIGHT        1

#define LINE1    0x80        // Start address of first line
#define LINE2    0xC0        // Start address of second line
#define LINE3    0x94
#define LINE4    0xD4

#define LCD_CLR             (LCD_DATA(CLEAR,CMD))
#define LCD_HOME            (LCD_DATA(HOME,CMD))

class LCD{
public:
LCD(PinName RS, PinName E, PinName d4, PinName d5, PinName d6, PinName d7);
void Clear(void);
void Write(char text[80]);
void RowSelect(int row);

protected:
    void Busy(void);
    void DATA(char data,char type);
    DigitalOut _RS, _E;
    BusOut _DBUS;
};
#endif