#include "mbed.h"
#include "atoh.h"


#define WAIT_TIME_S                                                    1
#define BAUD_RATE                                                      2250000
Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut led(PB_7);

int main()
{
    pc.format(8,SerialBase::None,1);
    pc.baud(BAUD_RATE);
    
    pc.printf("CPU %d Hz|||\n",SystemCoreClock);
    pc.printf("PCLK1 is %d Hz\r\n", HAL_RCC_GetPCLK1Freq());
    pc.printf("PCLK2 is %d Hz\r\n", HAL_RCC_GetPCLK2Freq());
    pc.printf("SYSCLK is %d Hz\r\n",HAL_RCC_GetSysClockFreq());
    
    
    
    //pc.printf("Press '1' to turn LED1 ON, '0' to turn it OFF\n");
    while(1) {
        char c = pc.getc(); // Read hyperterminal
        
        wait(WAIT_TIME_S);
        if (c == '0') {
            led = 0; // OFF
            if (pc.writeable()) {
                pc.printf("OFF\t");
            }
        }
        else if (c == '1') {
            led = 1; // ON
            if (pc.writeable()) {
                pc.printf("ON\t");
            }
        }
        else {
            //pc.putc(c);
            pc.printf( "%c = 0x%x\t",c,c);
        }
        wait(WAIT_TIME_S);
    }
}
