#include <stdint.h>
#include <stdio.h>

#include "mbed.h"
#include "communication.h"
#include "cube.h"

uint8_t message_buffer[MAX_MESSAGE_LENGTH];
int message_length = -1;

void clear_message_buffer()
{
    for(int i = 0; i < MAX_MESSAGE_LENGTH; i++)
        message_buffer[i] = 0;  
}  

void echo_message_buffer()
{
    printf("Message buffer - message of length %d\r\n",message_length);
    if(message_length < 1)
    {
       printf("\tINVALID!\r\n");
       return;
    }
    
    for(int i = 0; i < message_length; i++)
        printf("\tbyte %d: %c (0x%hhx)\r\n",i,message_buffer[i],message_buffer[i]);   
 
}

void receive_move_sequence(Serial* pc,mbed_info_t* sm)
{
    //printf("waiting for move sequence...\r\n");
    int i = 0;
    for(;;)
    {
        if(pc->readable())
        {
            message_buffer[i] = pc->getc();
            i++; 
        }
        if(i >= MAX_MESSAGE_LENGTH)
        {
            printf("Buffer overflow\r\n");
            break;
        }
        if(message_buffer[i-1] == '\r')
            break;
    }
    message_length = i;
    echo_message_buffer();
    serial_to_sequence(get_sequence(),message_buffer,i);
    print_sequence(get_sequence());
    sm->seq = get_sequence();
    reset_mbed();
}

void print_sample_sequence_hex()
{
    char move_str[] = "U  D  L  R  F  B  ";
    string_to_sequence(move_str);
    print_sequence(get_sequence());
    uint8_t hex_buf[100];
    int size = sequence_to_serial(get_sequence(),hex_buf,100);
    
    printf("Hex sequence, %d bytes\r\n",size);
    
    for(int i = 0; i < size; i++)
        printf("\tbyte %d: 0x%hhx\r\n",i,hex_buf[i]);  
}