#ifndef STRUCTS_H
#define STRUCTS_H
#include <Eigen/Dense.h>

using namespace Eigen;

// Union for easily converting floats to bytes for serial //
union f_b
{
float f;
uint8_t bytes[4];
};

union u16_b
{
    uint16_t i;
    uint8_t bytes[2];
};


typedef struct
{
    Vector2f q, qd, qdd, tau, g;
    Matrix2f h, c;
} StateStruct;
    
typedef struct
{
    int encoder_count[2];
    float q_sensed[2], qd_sensed[2];
}SensorStruct;
    
typedef struct
{
    float tau, p_setpoint, p_gain, v_setpoint, v_gain;
}ControlStruct;

typedef struct
{    
// Inputs //
u16_b p_setpoint, p_gain, v_setpoint, v_gain;
// Outputs //
u16_b encoder_0, encoder_1;
f_b q0, q1, qd0, qd1, torque_command;
}CommunicationStruct;
    
#endif
