#ifndef DYNAMICS_H
#define DYNAMICS_H

#include "mbed.h"
#include "../Eigen/Dense.h"
#include "../structs.h"

#define J0      .000115f
#define L0      .043f
#define B0      .00001f
#define J1      .00000237f
#define L1      .035f
#define M1      .0054f
#define B1      .00001f
#define G       9.8f

#define P_RES   4096    // Pendulum encoder resolution
#define B_RES   4096   // Base encoder resolution

#define PI      3.14159265359f

void integrate_state(StateStruct * state, float torque, float dt);
void update_sensors(StateStruct state, SensorStruct * sensors);
#endif