
#include "mbed.h"
#include "hw_setup.h"
#include "hw_config.h"
#include "structs.h"
#include "FastPWM.h"

void Init_PWM(GPIOStruct *gpio){
    
    //RCC->AHBENR |= RCC_AHBENR_GPIOCEN; // enable the clock to GPIOC
    //RCC->APB1ENR |= RCC_APB1ENR_TIM2EN; // enable TIM2 clock
    //RCC->APB2ENR |= RCC_APB2ENR_TIM1EN; // enable TIM1 clock

    //GPIOC->MODER = (1 << 8); // set pin 4 to be general purpose output
    gpio->enable = new DigitalOut(ENABLE_PIN);
    gpio->pwm_u = new PwmOut(PIN_U);
    gpio->pwm_v = new PwmOut(PIN_V);
    gpio->pwm_w = new PwmOut(PIN_W);
    
     //ISR Setup     
    
    NVIC_EnableIRQ(TIM1_UP_TIM16_IRQn);   //Enable TIM1 IRQ

    TIM1->DIER |= TIM_DIER_UIE; // enable update interrupt
    TIM1->CR1 |= 0x40;//CMS = 10, interrupt only when counting up
    TIM1->CR1 |= TIM_CR1_UDIS;
    TIM1->CR1 |= TIM_CR1_ARPE; // autoreload on, 
    TIM1->RCR |= 0x001; // update event once per up/down count of4 tim1 
    TIM1->EGR |= TIM_EGR_UG;
 
    //PWM Setup

    TIM1->PSC = 0x0; // no prescaler, timer counts up in sync with the peripheral clock
    TIM1->ARR = 0x708;    //40 khz
    TIM1->CCER |= ~(TIM_CCER_CC1NP); //Interupt when low side is on.
    TIM1->CR1 |= TIM_CR1_CEN;    
    
    }

void Init_ADC(void){
        // ADC Setup
     RCC->AHBENR |= RCC_AHBENR_ADC12EN; // clock for ADC1,2
     RCC->AHBENR |= RCC_AHBENR_GPIOCEN; // enable the clock to GPIOC
     GPIOC->MODER |= 0x0000000f; // PC_0, PC_1 are analog inputs 
     ADC12_COMMON->CCR |=  0x6; // Regular simultaneous mode only
     ADC12_COMMON->CCR |= 0x0000; //CKMODE = 1;
     
     
     ADC1->SQR1 = 0x180; // use PC_0 as input - CH6
     //ADC1->IER |= ADC_IER_EOCIE; //EOC flag on
     
     ADC2->SQR1 = 0x1C0; // use PC_1 as input - CH7

     ADC1->SMPR1 |= (0x7<<18); //Sample time
     ADC2->SMPR1 |= (0x7<<21); //Sample time
     
     ADC1->CR |= ADC_CR_ADEN; // ADC1 ON
     ADC2->CR |= ADC_CR_ADEN; // ADC2 ON
     
     GPIOC->MODER = (1 << 8); // set pin 4 to be general purpose output
     }

void Init_DAC(void){
     RCC->APB1ENR |= RCC_APB1ENR_DAC1EN; // Enable clock for DAC
     DAC->CR |= DAC_CR_EN1; // DAC control reg, both channels ON
     GPIOA->MODER |= 0x00000300; // PA04 as analog output  
    }

void Init_All_HW(GPIOStruct *gpio){
    Init_PWM(gpio);
    Init_ADC();
    //Init_DAC();
    
    }