
#include "foc.h"
#include "mbed.h"
#include "hw_config.h"
#include "math.h"
#include "math_ops.h"
#include "motor_config.h"
#include "current_controller_config.h"
#include "FastMath.h"
using namespace FastMath;


void abc( float theta, float d, float q, float *a, float *b, float *c){
    ///Phase current amplitude = lengh of dq vector///
    ///i.e. iq = 1, id = 0, peak phase current of 1///

    *a = d*FastCos(-theta) + q*FastSin(-theta);
    *b = d*FastCos((2.0f*PI/3.0f)-theta) + q*FastSin((2.0f*PI/3.0f)-theta);
    *c =  d*FastCos((-2.0f*PI/3.0f)-theta) + q*FastSin((-2.0f*PI/3.0f)-theta);
    }
    
void dq0(float theta, float a, float b, float c, float *d, float *q){
    ///Phase current amplitude = lengh of dq vector///
    ///i.e. iq = 1, id = 0, peak phase current of 1///
    
    *d = (2.0f/3.0f)*(a*FastCos(-theta) + b*FastCos((2.0f*PI/3.0f)-theta) + c*FastCos((-2.0f*PI/3.0f)-theta));
    *q = (2.0f/3.0f)*(a*FastSin(-theta) + b*FastSin((2.0f*PI/3.0f)-theta) + c*FastSin((-2.0f*PI/3.0f)-theta));
    }
    
void svm(float v_bus, float u, float v, float w, float *dtc_u, float *dtc_v, float *dtc_w){
    ///u,v,w amplitude = v_bus for full modulation depth///
    
    float v_offset = (fminf3(u, v, w) + fmaxf3(u, v, w))/2.0f;
    *dtc_u = fminf(fmaxf(((u - v_offset)*0.5f/v_bus + 0.5f), DTC_MIN), DTC_MAX);
    *dtc_v = fminf(fmaxf(((v - v_offset)*0.5f/v_bus + 0.5f), DTC_MIN), DTC_MAX);
    *dtc_w = fminf(fmaxf(((w - v_offset)*0.5f/v_bus + 0.5f), DTC_MIN), DTC_MAX);
    
    }

void zero_current(int *offset_1, int *offset_2){
    int adc1_offset = 0;
    int adc2_offset = 0;
    int n = 1024;
    for (int i = 0; i<n; i++){
        ADC1->CR  |= ADC_CR_ADSTART;  
        volatile int eoc;
        while(!eoc){
            eoc = ADC1->ISR & ADC_ISR_EOC;
            }
        adc2_offset += ADC2->DR;
        adc1_offset += ADC1->DR;
        }
    *offset_1 = adc1_offset/n;
    *offset_2 = adc2_offset/n;
    }

void reset_foc(ControllerStruct *controller){
    controller->q_int = 0;
    controller->d_int = 0;
    }


void commutate(ControllerStruct *controller, GPIOStruct *gpio, float theta){
       
       controller->loop_count ++;
       controller->i_b = I_SCALE*(float)(controller->adc2_raw - controller->adc2_offset);    //Calculate phase currents from ADC readings
       controller->i_c = I_SCALE*(float)(controller->adc1_raw - controller->adc1_offset);
       controller->i_a = -controller->i_b - controller->i_c;
       
       
       dq0(controller->theta_elec, controller->i_a, controller->i_b, controller->i_c, &controller->i_d, &controller->i_q);    //dq0 transform on currents
       
       ///Controller///
       float i_d_error = controller->i_d_ref - controller->i_d;
       float i_q_error = controller->i_q_ref - controller->i_q;
       //float v_d_ff = 2.0f*(2*controller->i_d_ref*R_PHASE);   //feed-forward voltage
       //float v_q_ff = 2.0f*(2*controller->i_q_ref*R_PHASE + controller->dtheta_elec*WB*0.8165f);
       controller->d_int += i_d_error;   
       controller->q_int += i_q_error;
       
       //v_d_ff = 0;
       //v_q_ff = 0;
       
       limit_norm(&controller->d_int, &controller->q_int, V_BUS/(K_Q*KI_Q));
       //controller->d_int = fminf(fmaxf(controller->d_int, -D_INT_LIM), D_INT_LIM);
       //controller->q_int = fminf(fmaxf(controller->q_int, -Q_INT_LIM), Q_INT_LIM);
       
       
       controller->v_d = K_D*i_d_error + K_D*KI_D*controller->d_int;// + v_d_ff;  
       controller->v_q = K_Q*i_q_error + K_Q*KI_Q*controller->q_int;// + v_q_ff; 
       
       //controller->v_d = v_d_ff;
       //controller->v_q = v_q_ff; 
       
       limit_norm(&controller->v_d, &controller->v_q, controller->v_bus);
       
       abc(controller->theta_elec, controller->v_d, controller->v_q, &controller->v_u, &controller->v_v, &controller->v_w); //inverse dq0 transform on voltages
       svm(controller->v_bus, controller->v_u, controller->v_v, controller->v_w, &controller->dtc_u, &controller->dtc_v, &controller->dtc_w); //space vector modulation

       //gpio->pwm_u->write(1.0f-controller->dtc_u);  //write duty cycles
       //gpio->pwm_v->write(1.0f-controller->dtc_v);
       //gpio->pwm_w->write(1.0f-controller->dtc_w);  
       
        //TIM1->CCR1 = 0x708*(1.0f-controller->dtc_u);
        //TIM1->CCR2 = 0x708*(1.0f-controller->dtc_v);
        //TIM1->CCR3 = 0x708*(1.0f-controller->dtc_w);
       
       controller->theta_elec = theta;   //For some reason putting this at the front breaks thins
       

       //if(controller->loop_count >1000){
           //controller->i_q_ref = -controller->i_q_ref;
       //    controller->loop_count  = 0;
           
           //printf("%f\n\r", controller->dtheta_elec);
           //printf("%f\n\r", controller->theta_elec);
           //pc.printf("%f    %f    %f\n\r", controller->i_a, controller->i_b, controller->i_c);
           //pc.printf("%f    %f\n\r", controller->i_d, controller->i_q);
           //pc.printf("%d    %d\n\r", controller->adc1_raw, controller->adc2_raw);
        //    }
    }
/*    
void zero_encoder(ControllerStruct *controller, GPIOStruct *gpio, ){
    
    }
*/    