#ifndef POSITIONSENSOR_H
#define POSITIONSENSOR_H
class PositionSensor {
public:
    virtual float GetMechPosition() {return 0.0f;}
    virtual float GetElecPosition() {return 0.0f;}
    virtual float GetMechVelocity() {return 0.0f;}
    virtual float GetElecVelocity() {return 0.0f;}
};
  
  
class PositionSensorEncoder: public PositionSensor {
public:
    PositionSensorEncoder(int CPR, float offset, int ppairs);
    virtual void Sample();
    virtual float GetMechPosition();
    virtual float GetElecPosition();
    virtual float GetMechVelocity();
    virtual float GetElecVelocity();
private:
    InterruptIn *ZPulse;
    DigitalIn *ZSense;
    //DigitalOut *ZTest;
    virtual void ZeroEncoderCount(void);
    virtual void ZeroEncoderCountDown(void);
    int _CPR, flag, rotations, _ppairs;
    //int state;
    float _offset, MechPosition, MechOffset, dir, test_pos, oldVel, out_old, velVec[16];
};

class PositionSensorMA700: public PositionSensor{
public:
    PositionSensorMA700(int CPR, float offset, int ppairs);
    virtual void Sample();
    virtual float GetMechPosition();
    virtual float GetElecPosition();
    virtual float GetMechVelocity();
    virtual int GetRawPosition();
    virtual void ZeroPosition();
private:
    float _offset, MechPosition, MechOffset;
    int _CPR, rotations, old_counts, _ppairs;
    SPI *spi;
    DigitalOut *cs;
};

class PositionSensorAM5147: public PositionSensor{
public:
    PositionSensorAM5147(int CPR, float offset, int ppairs);
    virtual void Sample();
    virtual float GetMechPosition();
    virtual float GetElecPosition();
    virtual float GetMechVelocity();
    virtual int GetRawPosition();
    virtual void ZeroPosition();
private:
    float position, ElecPosition, ElecOffset, MechPosition, MechOffset, modPosition, oldModPosition, oldVel, velVec[16], MechVelocity, ElecVelocity;
    int raw, _CPR, rotations, old_counts, _ppairs;
    SPI *spi;
    DigitalOut *cs;
    int readAngleCmd;

};

#endif