#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "ExperimentServer.h"
#include "QEI.h"
#include "MotorShield.h" 
#include "HardwareSetup.h"

#define NUM_INPUTS 2
#define NUM_OUTPUTS 3

Serial pc(USBTX, USBRX);    // USB Serial Terminal
ExperimentServer server;    // Object that lets us communicate with MATLAB
Timer t;                    // Timer to measure elapsed time of experiment

QEI encoderA(PE_9,PE_11, NC, 1200, QEI::X4_ENCODING);  // MOTOR A ENCODER (no index, 1200 counts/rev, Quadrature encoding)
QEI encoderB(PA_5, PB_3, NC, 1200, QEI::X4_ENCODING);  // MOTOR B ENCODER (no index, 1200 counts/rev, Quadrature encoding)
QEI encoderC(PC_6, PC_7, NC, 1200, QEI::X4_ENCODING);  // MOTOR C ENCODER (no index, 1200 counts/rev, Quadrature encoding)
QEI encoderD(PD_12, PD_13, NC, 1200, QEI::X4_ENCODING);// MOTOR D ENCODER (no index, 1200 counts/rev, Quadrature encoding)

AnalogIn currentA(PF_12); //MOTOR A CURRENT SENSOR 
AnalogIn currentB(PF_11); //MOTOR B CURRENT SENSOR 
AnalogIn currentC(PF_13); //MOTOR C CURRENT SENSOR 
AnalogIn currentD(PA_4);  //MOTOR D CURRENT SENSOR 

MotorShield motors(1000); //initialize the motor shield with a period of 1000 ticks or xxx kHZ

int main (void)
{
    // Link the terminal with our server and start it up
    server.attachTerminal(pc);
    server.init();

    // Continually get input from MATLAB and run experiments
    float input_params[NUM_INPUTS];
    pc.printf("%f",input_params[0]);
    
    while(1) {
        if (server.getParams(input_params,NUM_INPUTS)) {
            float v1   = input_params[0]; // Voltage for first second
            float v2   = input_params[1]; // Voltage for second second

            // Setup experiment
            t.reset();
            t.start();
            encoderA.reset();
            encoderB.reset();
            encoderC.reset();
            encoderD.reset();

            motors.motorAWrite(0, 0); //turn motor A off

            // Run experiment
            while( t.read() < 2 ) {
                // Perform control loop logic
                if (t.read() < 1)
                    motors.motorAWrite(v1, 0); //run motor A at "v1" duty cycle and in the forward direction 
                else
                    motors.motorAWrite(v2, 0); //run motor A at "v2" duty cycle and in the forward direction 

                // Form output to send to MATLAB
                float output_data[NUM_OUTPUTS];
                output_data[0] = t.read();
                output_data[1] = encoderA.getPulses();
                output_data[2] = encoderA.getVelocity();

                // Send data to MATLAB
                server.sendData(output_data,NUM_OUTPUTS);
                wait(.001);
            }
            // Cleanup after experiment
            server.setExperimentComplete();
            motors.motorAWrite(0, 0); //turn motor A off
        } // end if
    } // end while
    
} // end main

