#include "mbed.h"

//InterruptIn event(USER_BUTTON);

InterruptIn tilt(PC_5);
InterruptIn shake(PC_6);

DigitalIn tiltButton(PC_5);
DigitalIn shakeButton(PC_6);

DigitalOut myled(LED1);

int timeOut = 10;

void wakeMode() {    
    tilt.disable_irq();
    shake.disable_irq();       
}

void tiltIRQ() {
    printf("WAKE - Tilt!\n");  
    timeOut = 10;
    wakeMode();     
}

void shakeIRQ() {
    printf("WAKE - Shake!\n");  
    timeOut = 10; 
    wakeMode();
}

void sleepMode() {
    
    tilt.enable_irq();
    shake.enable_irq();
    
    tilt.fall(&tiltIRQ);
    shake.fall(&shakeIRQ);
    
    deepsleep();  
   
}

int main()
{
    
    sleepMode();

    printf("START\n");

    while (1) {

        printf("%d: Running\n", timeOut);
        myled = !myled;
        wait(.2);
        
        timeOut -= 1;

        if (tiltButton == 0) {
            printf("Tilt!\n");     
        }
        if (shakeButton == 0) {
            printf("Shake!\n");     
        }        

        if (timeOut == 0) {
            printf("Going to deep sleep...\n");
            sleepMode();   
        }

    }
    
}








