/* mbed Minimu-9 Library version 0beta1
 * Copyright (c) 2012 bengo
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include <minimu9.h>

// -------------------------------------------  
minimu9::minimu9( PinName sda, PinName scl ) :  _i2c(sda, scl), _lsm( sda, scl ), _l3g( sda, scl ) {
   _status = _lsm.getStatus() * _l3g.getStatus();
}

// -------------------------------------------
std::vector<short> minimu9::read( void ) {
   std::vector<short> data(9,0);
   std::vector<short> acc = _lsm.accRead();
   _status = _lsm.getStatus();
   if( _status == 0 ) {
      std::vector<short> mag = _lsm.magRead();
      _status = _lsm.getStatus();
      if( _status == 0 ) {
         std::vector<short> gyr = _l3g.read();
         _status = _l3g.getStatus();
         if( _status == 0 ) {
            for( int i=0; i<3; i++ ) {
               data[i  ] = acc[i];
               data[i+3] = mag[i];
               data[i+6] = gyr[i];
            }
         }
      }
   } 
   return( data );
}
