/* mbed L3G4200D Library version 0beta1
 * Copyright (c) 2012 bengo
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef L3G4200D_h
#define L3G4200D_h

#include "mbed.h"
#include <vector>

class L3G4200D {

public:

   /**
    * Create an L3G4200D object connected to the specified I2C pins
    * @param sda I2C SDA pin
    * @param scl I2C SCL pin
    */
   L3G4200D( PinName sda, PinName scl );
  
   /**
    * Return status code of prevoius function call
    */
   inline int getStatus( void ) { return( _status ); }  
   
   /**
    * Read specified register content
    * @param reg register address
    */  
   int registerRead(  int reg );

   /**
    * Write to specified register
    * @param reg register address
    * @parma data data to be written
    */     
   void registerWrite( int reg, char data );
  
   /**
    * read gyroscope vector
    */
   std::vector<short> read( void );

   /**
    * Read angular velogity (in degrees per second)
    */
   std::vector<float> angularVelocity( void );
   
   /**
    * Read temperature (in celsius)
    */
   int temperature( void );

   // Device registers addresses
   static const int WHO_AM_I;
   static const int CTRL_REG1;
   static const int CTRL_REG2;
   static const int CTRL_REG3;
   static const int CTRL_REG4;
   static const int CTRL_REG5;
   static const int REFERENCE;
   static const int OUT_TEMP;
   static const int STATUS_REG;
   static const int OUT_X_L;
   static const int OUT_X_H;
   static const int OUT_Y_L;
   static const int OUT_Y_H;
   static const int OUT_Z_L;
   static const int OUT_Z_H;
   static const int FIFO_CTRL_REG;
   static const int FIFO_SRC_REG;
   static const int INT1_CFG;
   static const int INT1_SRC;
   static const int INT1_THS_XH;
   static const int INT1_THS_XL;
   static const int INT1_THS_YH;
   static const int INT1_THS_YL;
   static const int INT1_THS_ZH;
   static const int INT1_THS_ZL;
   static const int INT1_DURATION;
   
private:

   int _status;
   I2C _i2c; 
   char _bytes[7];
   
   static const int GYR_ADDRESS;   

};

#endif //  L3G4200D_h