/* mbed L3G4200D Library version 0beta1
 * Copyright (c) 2012 bengo
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 #include <L3G4200D.h>

// L3G4200D I2C address
const int L3G4200D::GYR_ADDRESS = 0xd2; 
// L3G4200D register addresses
const int L3G4200D::WHO_AM_I = 0x0f;
const int L3G4200D::CTRL_REG1 = 0x20;
const int L3G4200D::CTRL_REG2 = 0x21;
const int L3G4200D::CTRL_REG3 = 0x22;
const int L3G4200D::CTRL_REG4 = 0x23;
const int L3G4200D::CTRL_REG5 = 0x24;
const int L3G4200D::REFERENCE = 0x25;
const int L3G4200D::OUT_TEMP = 0x26;
const int L3G4200D::STATUS_REG = 0x27;
const int L3G4200D::OUT_X_L = 0x28;
const int L3G4200D::OUT_X_H = 0x29;
const int L3G4200D::OUT_Y_L = 0x2a;
const int L3G4200D::OUT_Y_H = 0x2b;
const int L3G4200D::OUT_Z_L = 0x2c;
const int L3G4200D::OUT_Z_H = 0x2d;
const int L3G4200D::FIFO_CTRL_REG = 0x2e;
const int L3G4200D::FIFO_SRC_REG = 0x2f;
const int L3G4200D::INT1_CFG = 0x30;
const int L3G4200D::INT1_SRC = 0x31;
const int L3G4200D::INT1_THS_XH = 0x32;
const int L3G4200D::INT1_THS_XL = 0x33;
const int L3G4200D::INT1_THS_YH = 0x34;
const int L3G4200D::INT1_THS_YL = 0x35;
const int L3G4200D::INT1_THS_ZH = 0x36;
const int L3G4200D::INT1_THS_ZL = 0x37;
const int L3G4200D::INT1_DURATION = 0x38;

// -----------------------------------------------
L3G4200D::L3G4200D( PinName sda, PinName scl ) : _i2c( sda, scl ){

   // Check that you're talking with an L3G4200D device
   if( this->registerRead( WHO_AM_I ) == 0xd3 ) {
      _status = 0;
   }
   else {
      _status = 1;
      return;
   }
   
   // Enable normal mode... 
   this->registerWrite( CTRL_REG1, 0x0f );

}

// -----------------------------------------------
int L3G4200D::registerRead(  int reg ) {
  _bytes[0] = reg & 0xff;
  _status = _i2c.write( GYR_ADDRESS, _bytes, 1 );
  if( _status ==  0 ) {
    _status = _i2c.read(  GYR_ADDRESS + 1, _bytes, 1 );
    return( _bytes[0] );
  }
  return( 0 );
}

// -----------------------------------------------  
void L3G4200D::registerWrite( int reg, char data ) {
  _bytes[0] = reg & 0xff;
  _bytes[1] = data & 0xff;
  _status = _i2c.write( GYR_ADDRESS, _bytes, 2 );
}

// -----------------------------------------------  
std::vector<short> L3G4200D::read( void ) {
   std::vector<short> gyr( 3, 0 );
   _bytes[0] = OUT_X_L | (1<<7);
   _status = _i2c.write( GYR_ADDRESS, _bytes, 1 );
   if( _status == 0 ) {
      _status = _i2c.read( GYR_ADDRESS + 1, _bytes, 6 );
      if( _status == 0 ) {
         for( int i=0; i<3; i++ ) {
            gyr[i] = short( _bytes[2*i] | ( _bytes[2*i+1] << 8 ));
         }
      }
   } 
   return( gyr );
}

// -----------------------------------------------  
std::vector<float> L3G4200D::angularVelocity( void ) {

   std::vector<float> angv(3, 0);
   const float fs[] = { 250., 500., 2000., 2000. }; 
   float fullscale =  fs[ ( this->registerRead( L3G4200D::CTRL_REG4 ) >> 4 ) & 0x3 ];
   std::vector<short> g = this->read();
   if( _status == 0 ) {
      for( int i=0; i<3; i++ ) {
         angv[i] = float( g[i] ) / 32768. * fullscale;
      }
   }
   return( angv ); 
}  


// -----------------------------------------------  
int L3G4200D::temperature( void ) {

   _bytes[0] = OUT_TEMP;
   _status = _i2c.write( GYR_ADDRESS, _bytes, 1 );
   if( _status == 0 ) {
      _status = _i2c.read( GYR_ADDRESS + 1, _bytes, 1 );
      if( _status == 0 ) {
         return( int( _bytes[0] ) );
      }
   } 
   return( 0 );
}