/* mbed LSM303 Library version 0beta1
 * Copyright (c) 2012 bengo
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef LSM303_h
#define LSM303_h

#include "mbed.h"
#include <vector>

class LSM303 {

public:

   /**
    * Create an LSM303 object connected to the specified I2C pins
    * @param sda I2C SDA pin
    * @param scl I2C SCL pin
    */  
   LSM303( PinName sda, PinName scl );

   /**
    * Return status code of prevoius function call
    */  
   inline int getStatus( void ) { return( _status ); }  
  
   /**
    * Read specified accelerometer register content
    * @param reg register address
    */ 
   int accRegisterRead( int reg );

   /**
    * Write to specified accelerometer register
    * @param reg register address
    * @parma data data to be written
    */  
   void accRegisterWrite( int reg, char data );

   /**
    * Read specified magnetometer register content
    * @param reg register address
    */   
   int magRegisterRead( int reg );

   /**
    * Write to specified magnetometer register
    * @param reg register address
    * @parma data data to be written
    */   
   void magRegisterWrite( int reg, char data );
  
   /**
    * Read accelerometer vector
    */
   std::vector<short> accRead( void );
   
    /**
    * Read acceleration 
    */
   std::vector<float> acceleration( void );

   /**
    * Read magnetometer vector
    */
   std::vector<short> magRead( void );
   
   /**
    * Read magnetic field vector
    */
    std::vector<float> magneticField( void );
  
   // Device registers addresses
   static const int ACC_CTRL_REG1;
   static const int ACC_CTRL_REG2;
   static const int ACC_CTRL_REC3;
   static const int ACC_CTRL_REG4;
   static const int ACC_CTRL_REG5;
   static const int ACC_HP_FILTER_RESET;
   static const int ACC_REFERENCE;
   static const int ACC_STATUS_REG;
   static const int ACC_OUT_X_L;
   static const int ACC_OUT_X_H;
   static const int ACC_OUT_Y_L;
   static const int ACC_OUT_Y_H;
   static const int ACC_OUT_Z_L;
   static const int ACC_OUT_Z_H;
   static const int ACC_INT1_CFG;
   static const int ACC_INT1_SOURCE;
   static const int ACC_INT1_THS;
   static const int ACC_INT1_DURATION;
   static const int ACC_INT2_CFG;
   static const int ACC_INT2_SOURCE;
   static const int ACC_INT2_THS;
   static const int ACC_INT2_DURATION;
   static const int MAG_CRA_REG;
   static const int MAG_CRB_REG;
   static const int MAG_MR_REG;
   static const int MAG_OUT_X_H;
   static const int MAG_OUT_X_L;
   static const int MAG_OUT_Y_H;
   static const int MAG_OUT_Y_L;
   static const int MAG_OUT_Z_H;
   static const int MAG_OUT_Z_L;
   static const int MAG_SR_REG;
   static const int MAG_IRA_REG;
   static const int MAG_IRB_REG;
   static const int MAG_IRC_REG;
   static const int MAG_WHO_AM_I;
  
private:

   int _status;
   I2C _i2c; 
   int _SA0Pad;
   char _bytes[7];
  
   static const int ACC_ADDRESS;
   static const int MAG_ADDRESS;
  
};

#endif // LSM303_h