#include "mbed.h"
#include "UnivTrans.h"

TextLCD lcd(p14, p16, p17, p18, p19, p20); // rs, e, d4-d7
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
    
EthernetNetIf eth;                  //  Ethernet Control
HTTPClient http;                    //  HTTP Client Stack Library
    
VS1002 mp3(                         //  Initialize MP3 Hardware Decoder class
                p5, p6, p7, p8, "sd",   //  SD Card SPI Connections & Setup
                p11, p12, p13, p10,     //  VS1053/1002 SPI Connections
                p21, p22, p23, p15);    //  DREQ,DCS,VOL
                                        //  Due to the current TextLCD setup, the only Analog pin
                                        //  available is p15, thus it is used for volume control

int main() {
    Serial pc(USBTX, USBRX);
    PS2Keyboard KeyB(p29, p30);        //  CLK, DAT
    Ticker tm;                          //  Controls Blinking of LEDs/consistent ops
    
    //  Start Setting Up Hardware
    printf("Setting up...\n");
    EthernetErr ethErr = eth.setup();
    if(ethErr) {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("Setup OK\n");
    
    //  Initialize MP3 Hardware
    #ifndef FS_ONLY
    mp3._RST = 1;
    mp3.cs_high();                                   //chip disabled
    mp3.sci_initialise();                            //initialise MBED
    mp3.sci_write(0x00,(SM_SDINEW+SM_STREAM+SM_DIFF));
    mp3.sci_write(0x03, 0x9800);
    mp3.sdi_initialise();
    #endif
    
    //Blink now to signal successful hardware/internet setup
    tm.attach(&blink,.5);   
    
    //Now let's get to the real code
    
    char rowstring[6*16];
    memset(rowstring,0,6*16);
    
    while(true){
        checkKeys(KeyB,rowstring);
        Net::poll();
    }
    
    return 0;
}