#include "UnivTrans.h"

static const unsigned char ps2KeyMap[] = {
//   0    1    2    3    4    5    6    7    8    9    A    B    C    D    E    F
  '\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0', '`','\0', // 00-0F
  '\0','\0','\0','\0','\0', 'Q', '1','\0','\0','\0', 'Z', 'S', 'A', 'W', '2','\0', // 10-1F
  '\0', 'C', 'X', 'D', 'E', '4', '3','\0','\0',' ', 'V', 'F', 'T', 'R', '5','\0', // 20-2F
  '\0', 'N', 'B', 'H', 'G', 'Y', '6','\0','\0', '\0', 'M', 'J', 'U', '7', '8','\0', // 30-3F
  '\0', ',', 'K', 'I', 'O', '0', '9','\0','\0', '.', '/', 'L', ';', 'P', '-','\0', // 40-4F
  '\0','\0', '\'','\0', '[', '=','\0','\0','\0','\0','\0', ']','\0','\\','\0','\0', // 50-5F
  '\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0', // 60-6F
  '\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0', // 70-7F
  '\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0', // 80-8F
  '\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0', // 90-9F
  '\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0', // A0-AF
  '\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0', // B0-BF
  '\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0', // C0-CF
  '\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0', // D0-DF
  '\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0', // E0-EF
  '\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0', // F0-FF
};

void checkKeys(PS2Keyboard &ps2kb,char* rowstr) {
    static int column = 0;
    static int row = 0;
    static int selected = true;
    static int source = false;
    static const char *selsrc="Select Src Lang\n";
    static const char *seldest="Select Dest Lang";
    static string httpurl = "http://translate.google.com/translate_tts?tl=";
    static string httptransurl = " ";//INSERT YOUR WEBSITE HERE!
    static string arg = "&q=";
    string voiceurl;
    string transurl;
    static int src=26;
    static int dest=37;
    string lang;
    string translatedText;
    static PS2Keyboard::keyboard_event_t evt_kb;
if (ps2kb.processing(&evt_kb)) {
        for (int i = 0; i < evt_kb.length; i++) {
            if(evt_kb.type == 1) {
                if(!selected) {
                        if (evt_kb.scancode[i] == 0x72) {//down arrow
                            if (source) src++;
                            else dest++;
                            lang = getLang(source?src:dest);
                        } else if (evt_kb.scancode[i] == 0x75) { //up arrow
                            if (source && src!=0) src--;
                            else if (!source && dest!=0) dest--;
                            lang = getLang(source?src:dest);
                        } else if(evt_kb.scancode[i] == 0x5A) {
                            if(source) { 
                                source = false;
                                lang = getLang(dest);
                            } else selected = true;
                        }
                        if(selected) {
                            lcd.cls();
                            voiceurl += httpurl;
                            voiceurl += getLangCode(dest);
                            voiceurl += arg;
                            transurl += httptransurl;
                            transurl += getLangCode(src);
                            transurl += "&dest=";
                            transurl += getLangCode(dest);
                            transurl += arg;
                            encodeURL(transurl,rowstr);
                            printf("%s",transurl.c_str());
                            HTTPText t;
                            HTTPResult r = http.get(transurl.c_str(),&t);
                            if(r==HTTP_OK) {
                                printf("Result OK\n");
                            } else {
                                printf("Error %d\n", r);
                            }
                            translatedText=t.get();
                            encodeURL(voiceurl,translatedText.c_str());
                            printf("%s",voiceurl.c_str());
                            HTTPFile f("/sd/alaha.mp3");
                            r = http.get(voiceurl.c_str(), &f);
                            if(r==HTTP_OK) {
                                printf("Result OK\n");
                            } else {
                                printf("Error %d\n", r);
                            }
                            mp3.play_song(1);
                            voiceurl.erase();
                            transurl.erase();
                            memset(rowstr,0,6*16);
                        } else {
                            lcd.cls();
                            lcd.printf(source?selsrc:seldest);
                            lcd.printf(lang.c_str());
                        }
                } else {
                if (ps2KeyMap[evt_kb.scancode[i]] != '\0'){
                    if(row == 0){
                        rowstr[(row*16)+column]=ps2KeyMap[evt_kb.scancode[i]];
                        if(column > 14) {
                            column = 0;
                            row++;
                            if(row > 6) row = 0;
                        }
                        else column++;
                        lcd.cls();
                        for(int j = 0; j < 32; j++) {
                            if(rowstr[(row*16)+j] != '\0') lcd.printf("%c", rowstr[(row*16)+j]);
                            if((j+1) == column) lcd.printf("%c", '\0');
                        }
                    } else {
                        rowstr[(row*16)+column]=ps2KeyMap[evt_kb.scancode[i]];
                        if(column > 14) {
                            column = 0;
                            row++;
                            if(row > 6) row = 0;
                        }
                        else column++;
                        lcd.cls();
                        for(int j = 0; j < 32; j++) {
                            if(rowstr[((row-1)*16)+j] != '\0') lcd.printf("%c", rowstr[((row-1)*16)+j]);
                            if((j+1) == (column+16)) lcd.printf("%c", '\0');
                        }
                    }
                }
               if (evt_kb.scancode[i] == 0x66) {//backspace deletes a character
                    if(column > 0) column--;
                    else {
                        if (row != 0) {
                            column = 15;
                            row--;
                        }
                    }
                    rowstr[(row*16)+column] = '\0';
                    lcd.cls();
                    if (row != 0) {
                        for(int j = 0; j < 32; j++) {
                            if(rowstr[((row-1)*16)+j] != '\0') lcd.printf("%c", rowstr[(row-1)*16+j]);
                        }
                    } else {
                        for(int j = 0; j < 32; j++) {
                            if(rowstr[(row*16)+j] != '\0') lcd.printf("%c", rowstr[(row)*16+j]);
                        }
                    }
                }
                if (evt_kb.scancode[i] == 0x5A) {//enter sends the message   
                    selected = false;
                    source = true;
                    lang = getLang(src);
                    lcd.cls();
                    lcd.printf(selsrc);
                    lcd.printf(lang.c_str());
                    row = 0;
                    column = 0;
                    return;
                }
                if (evt_kb.scancode[i] == 0x75) {//up arrow
                    if(row > 1) {
                        lcd.cls();
                        row = row - 1;
                        for(int j = 0; j < 32; j++) {
                            if(rowstr[((row-1)*16)+j] != '\0') lcd.printf("%c", rowstr[((row-1)*16)+j]);
                        }
                        lcd.locate(column, 1);
                        lcd.printf("%c", '\0');
                    } else {
                        if (row == 1) {
                            row = row - 1;
                            lcd.locate(column, row);
                            lcd.printf("%c", '\0');
                        }
                    }
                    
                }
                if (evt_kb.scancode[i] == 0x72) {//down arrow
                    if(rowstr[((row+1))+column] != '\0'){
                        lcd.cls();
                        for(int j = 0; j < 32; j++) {
                            if(rowstr[(row*16)+j] != '\0') lcd.printf("%c", rowstr[(row*16)+j]);
                        }
                        row = row + 1;
                        lcd.locate(column, 1);
                        lcd.printf("%c", '\0');
                    }
                }
                if (evt_kb.scancode[i] == 0x6B) {//left arrow
                    if((column !=0)) {
                            if(row == 0){
                                column = column - 1;
                                lcd.cls();
                                for(int j = 0; j < 32; j++) {
                                    if(rowstr[(row*16)+j] != '\0') lcd.printf("%c", rowstr[(row*16)+j]);
                                }
                                lcd.locate(column, 0);
                                lcd.printf("%c", '\0');
                            } else {
                                column = column - 1;
                                lcd.cls();
                                for(int j = 0; j < 32; j++) {
                                    if(rowstr[((row-1)*16)+j] != '\0') lcd.printf("%c", rowstr[((row-1)*16)+j]);
                                }
                                lcd.locate(column, 1);
                                lcd.printf("%c", '\0');
                            }
                    }
                }
                if (evt_kb.scancode[i] == 0x74) {//right arrow
                   if(rowstr[(row*16)+column+1] != '\0'){
                       if(column != 15){
                           column = column + 1;
                           if (row == 0){
                               lcd.cls();
                               for(int j = 0; j < 32; j++) {
                                   if(rowstr[(row*16)+j] != '\0') lcd.printf("%c", rowstr[(row*16)+j]);
                               }
                               lcd.locate(column, 0);
                               lcd.printf("%c", '\0');
                           } else {
                               lcd.cls();
                               for(int j = 0; j < 32; j++) {
                                   if(rowstr[((row-1)*16)+j] != '\0') lcd.printf("%c", rowstr[((row-1)*16)+j]);
                               }
                               lcd.locate(column, 1);
                               lcd.printf("%c", '\0');
                           }
                       }
                   }
               }

                if (evt_kb.scancode[i] == 0x71) {//delete key will clear everything
                    memset(rowstr,0,6*16);
                    lcd.cls();
                    row = 0;
                    column = 0;
                }
            }
            }
        }
    }
}
