#ifndef MEASURE_H
#define MEASURE_H

#ifndef MEASURE_C
#define EXTERN extern
#else
#define EXTERN  
#endif

#include "mbed.h"
#include <string>
using namespace std;

const int MAX_PROBES = 2;
//File system
#define        DATA_FOLDER        "/sd/data"
#define        LOGGER_FILE        "/sd/syslog/log.txt"
#define        STATUS_FILE        "/local/status.dat"
#define        LOGIN_FILE         "/local/4j7k2fo5.tzh"
#define        CONFIG_FILE        "/local/config.txt"
#define        FILELIST_FILE      "/sd/system/files.dat"
#define        SOURCE_FILE        "/sd/index.htm"
#define        TARGET_FILE        "/local/index.htm"
//File copy
#define        COPY_BLOCK_SIZE    512
//Network
#define        NOINTERNET         ""
//File writer
#define WRITEFILE       1
#define APPENDFILE      2
#define READFILE        0
//Com
#define BAUDRATE        921600

//GLobal function definitions
EXTERN void InitDS1820(void);//Init DS1820 array
EXTERN void GetMyIP(void);
EXTERN void IndexInit(void);
EXTERN void UpdateLCD(int counter);
EXTERN void UpdateTime(void);
EXTERN void LoadConfig(void);
EXTERN void LoadStatus(void);
EXTERN void LogWrite(string stringin);
EXTERN char sdcardIsFileExist(const char *fileName);
EXTERN bool exists(char * root, char *filename);
EXTERN char sdcardWriteFile(const char *fileName, char mode, char *data);
EXTERN void MeasureLogger(int force);
EXTERN void MeasureStart(void);
EXTERN void MeasureStop(void);
EXTERN void SaveStatus(void);
EXTERN void SaveConfig(void);
EXTERN void PrintRAM(void);
EXTERN void UpdateList(void);
extern "C" void mbed_reset();

EXTERN void GetFile(int index, char *st);
//Global vars
EXTERN int clockoffset;
EXTERN time_t ctTime;  //Time var
EXTERN  bool HandlerActive;
EXTERN int interval;
EXTERN int logging;
EXTERN char * logfile ;
EXTERN int postOK;
EXTERN bool reset;
#endif

#undef EXTERN
#undef MEASURE_C