#define MEASURE_C
#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "SDFileSystem.h"
#include "TextLCD.h"
#include "DS1820.h"
#include "MeasureSystem.h"
#include "WatchDog.h"
//#include "HTTPClient.h"
#include "AvailableMemory.h"

//-------------------Defines--------------------------------


//-----------------Objects----------------------
EthernetNetIf *eth;            //Network IP stack
HTTPServer svr;                //HTTP server
Serial pc(USBTX, USBRX);       // Serial debug usb port
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
LocalFileSystem local("local");//Internal flash
SDFileSystem sd(p5, p6, p7, p8, "sd"); // // External sd card
TextLCD lcd(p21, p22, p23, p24, p25, p26,  TextLCD::LCD20x4 );  //Char lcd
watchdog wdog(15);              // Watch dog timer 15 seconds
DS1820* probe[MAX_PROBES];      //Temp sensors

//------status flags-----------------
int devices_found=0;
char wanIP[18];
char localIP[18];
int fileindex =0;
bool getIPfromDHCP;
bool localmode;
Timer timerMeasure;
int ipConfig[4];
int maskConfig[4];
int gatewayConfig[4];
int dnsConfig[4];
int handlerCounter =0;
string myUrl;
int  measureCommand;
//---------------------MAIN-----------------------
int main() {
    reset = false;
    //Init serial com
    pc.baud(BAUDRATE);
    logfile = new char[50];
    //Init flags
    measureCommand = 0;
    HandlerActive = false;
    postOK = 0;

    //Init local variables for init sequence
    char buf[40];
    string tempstring = ("");
    //-----------------LCD test-------------------
    printf("\r\n\r\n<----------------------------------------------->");
    printf("\r\n<System Startup>\r\n");
    PrintRAM();
    lcd.cls();
    lcd.printf("LCD Init.......Done\n");
    wait(0.2);

    //----------------SD.card test----------------
    printf("<SD card init>\r\n");
    lcd.printf("SDcard Init....");
    mkdir(DATA_FOLDER, 0777);
    FILE *fp = fopen(LOGGER_FILE, "a+");
    if (fp == NULL) {
        error("Could not open file for write\r\n");
    } else {
        fprintf(fp, "<-------------------->\r\n");
        fclose(fp);
        tempstring ="SYSTEM STARTUP";
        LogWrite(tempstring);
    }
    lcd.printf("Done\n");


    wdog.feed();
    //----------------DS1820 init-----------------
    printf("<DS1820 init>\r\n");
    lcd.printf("Init sensors.");
    InitDS1820();
    lcd.printf(".Done\n");

    wdog.feed();
    //--------------Read config.txt---------------
    LoadConfig();
    //---------------Network init-----------------
    lcd.printf("Network Init...");
    printf("<Network Init>\r\n");
    if (getIPfromDHCP) {
        eth = new EthernetNetIf();
    } else {
        eth = new EthernetNetIf(
            IpAddr(ipConfig[0],ipConfig[1],ipConfig[2],ipConfig[3]), //IP Address
            IpAddr(maskConfig[0],maskConfig[1],maskConfig[2],maskConfig[3]), //Network Mask
            IpAddr(gatewayConfig[0],gatewayConfig[1],gatewayConfig[2],gatewayConfig[3]), //Gateway
            IpAddr(dnsConfig[0],dnsConfig[1],dnsConfig[2],dnsConfig[3])  //DNS
        );
    }
    EthernetErr ethErr = eth->setup(10000);
    if (ethErr) {
        printf("Error %d in setup.\r\n", ethErr);
        lcd.printf("Error");
    }
    
    sprintf(buf,"%d.%d.%d.%d",
            eth->getIp()[0], eth->getIp()[1], eth->getIp()[2], eth->getIp()[3]);
    sprintf(localIP,"%s",buf);
    printf("Setup OK\r\n");
    lcd.printf("Done\n");
    wdog.feed();

    //-----------------WAN check---------------------------

    wait(1);
    printf("<WAN Connection Check>\r\n");
    lcd.cls();
    lcd.printf("Internet conn..");
    GetMyIP();
    if (wanIP[0]!=0) {
        lcd.printf("Done\n");
        printf("OK: %s\r\n",wanIP);

    } else {
        lcd.printf("Fail\n");
        printf("No connection\r\n");
    }
    wdog.feed();
    //-----------------RTC INIT------------------------

    lcd.printf("RTClock Init...");
    printf("<RTC Init>\r\n");

    if (wanIP[0]!=0) {
        UpdateTime();
        strftime(buf,sizeof(buf), "%A %m/%d/%Y %H:%M:%S\n", localtime(&ctTime));
        printf("Time is now : %s JST\r\n", buf);
        lcd.printf("Done\n");
    } else {
        printf("Cannot connect NTP Server!!\r\n");
        lcd.printf("Fail\n");
    }

    wdog.feed();

    //-------Init index.htm in local filesystem---------
    lcd.printf("Loading config.");
    LoadStatus();
    IndexInit();
    if (logging == 1) {
        timerMeasure.start();
    }
    lcd.printf("Done\n");
    wdog.feed();
    //-----------------Welcome message------------------
    wait(2);
    lcd.cls();
    lcd.printf("Welcome to mbed. \nMeasure system.\n");
    lcd.printf("IP: %s\n",localIP);
    //--------------HTTP SERVER-------------------------

    FSHandler::mount("/local", "/"); //Mount /wwww path on web root path
    FSHandler::mount("/sd", "/extern"); //Mount /wwww path on web root path
    svr.addHandler<FSHandler>("/files");//  this does not see the subdirectory
    svr.addHandler<FSHandler>("/"); //Default handler
    svr.addHandler<SimpleHandler>("/com"); //Com hander
    svr.bind(80);

    printf("<INIT DONE... Server running>\r\n");
    ctTime = time(NULL);
    ctTime += (clockoffset*3600);
    strftime(buf,sizeof(buf), "%Y/%m/%d %H:%M:%S", localtime(&ctTime));
    tempstring ="";
    tempstring += buf;
    LogWrite(tempstring);
    tempstring ="SYSTEM READY";
    LogWrite(tempstring);
    Timer tm;
    tm.start();
    //Listen indefinitely
    int counter =0;

    //-------------------MAIN LOOP--------------------
    while (true) {
        Net::poll(); // Network listen
        if (tm.read()>1) {
        //RESET REQUIED
        if (reset)
        {
        wait(1);
        mbed_reset();
        }
        
            counter = (counter++)%36000;  //Timer counter loop

            led1=!led1; //Show that we are alive 1 sec timed
            
            //Show if logging
            if (logging==1) {
                led4 =!led1;
            } else {
                led4 = 0;
            }
            
            //Refress LCD
            UpdateLCD(counter); 
            /*
            //If no network detected aat startup then try to connect every 30 sec
            if ( (wanIP[0]==0 & (counter%30)==0) | (wanIP[0]!=0 & (counter)==0)) {      
                GetMyIP();
                if (wanIP[0]!=0) {
                    IndexInit() ;
                    UpdateTime();
                }
            }
*/
            //DEADLOCK PREVENTER
            if (HandlerActive) {
                handlerCounter++;
            } else {
                handlerCounter = 0;
            }
            if (handlerCounter>60) {
                handlerCounter = 0;
                HandlerActive = false;
            }

            //Logger
            if (logging == 1 ) {
                MeasureLogger(0);
            }


            wdog.feed();
            tm.start();

PrintRAM();
        }

    }


}


//---------------------------Functions--------------------------


void InitDS1820() {

    int i;
// Initialize the probe array to DS1820 objects
    for (i = 0; i < MAX_PROBES; i++)
        probe[i] = new DS1820(p27);
// Initialize global state variables
    probe[0]->search_ROM_setup();
// Loop to find all devices on the data line
    while (probe[devices_found]->search_ROM() and devices_found<MAX_PROBES-1)
        devices_found++;
// If maximum number of probes are found,
    // bump the counter to include the last array entry
    if (probe[devices_found]->ROM[0] != 0xFF)
        devices_found++;

    if (devices_found==0)
        printf("No devices found");
    else {

        probe[0]->convert_temperature(DS1820::all_devices);
        for (i=0; i<devices_found; i++) {
            printf("%3.1f \r\n",probe[i]->temperature('c'));
        }
    }

    lcd.printf("%d",devices_found);
}

//-------------------Get WAN IP adress-------------------------

void GetMyIP() {
/*
    HTTPClient http;
    HTTPText txt;
    HTTPResult r
    //r = http.get("http://www.whatismyip.com/automation/n09230945NL.asp", &txt);
    if (r==HTTP_OK) {
        sprintf(wanIP,"%s", txt.gets());
    } else {
        sprintf(wanIP,NOINTERNET);
    }   

*/
sprintf(wanIP,NOINTERNET);

}

//-----------------Create Index HTM in local-------------------
void IndexInit() {
    FILE    *fs_src;
    FILE    *fs_tgt;
    char    buffer[ COPY_BLOCK_SIZE ];

    printf( "file copier started.\r\n" );
    printf( "  source:%s >>> target:%s\r\n", SOURCE_FILE, TARGET_FILE );

    if ( NULL == (fs_src    = fopen( SOURCE_FILE, "rb" )) ) {
        error( "couldn't open source file" );
    }
    if ( NULL == (fs_tgt    = fopen( TARGET_FILE, "wb" )) ) {
        error( "couldn't open target file" );
    }

    /*
        while (  size    = fread( s, sizeof( char ), COPY_BLOCK_SIZE, fs_src ) )
        {
            fwrite( s, sizeof( char ), size, fs_tgt );
            total    += size;

            led1    = (0x1 << progress_ind++ % 4);

            printf( "  %d bytes copied\r", total );
        }
     */
    string temp;
    char token[] = "ServerAddress";
    while (fgets(buffer, COPY_BLOCK_SIZE, fs_src)) {

        temp = string(buffer);
        int j=0;
        for (int i=0;i<COPY_BLOCK_SIZE;i++) {
            if (buffer[i]==token[j]) {
                j++;
            } else {
                j=0;
            }

            if (j==12) break;

            if (buffer[i]==0) {
                break;
            }
        }

        if (j==12) { //Change to find string element search by char.
            if (/*wanIP[0]!=0 &*/ !localmode) {
            fprintf(fs_tgt,"      <param name=\"ServerAddress\" value=\"%s\">",myUrl.c_str());
            }
            else
            {
            fprintf(fs_tgt,"      <param name=\"ServerAddress\" value=\"%s\">",localIP);
            }
        } else {
            fprintf(fs_tgt,"%s",temp.c_str());
        }
    }

    led1    = 0xF;

    fclose( fs_src );
    fclose( fs_tgt );

    printf( "done\r\n" );
}

//------------Update lcd------------------------------
bool IPshowflag = false;
void UpdateLCD(int counter) {
static int sensorcounter=0;
    char buf[40];

    if (counter%1==0) { //Every sec
        lcd.locate(0,1);
        if (logging) {
            lcd.printf("Logging with: %d ",interval);
        } else {
            lcd.printf("Not logging...      ");
        }
    }
    
        if (counter%2==0) {
        lcd.locate(0,0);
        if (devices_found>0)
        {
        lcd.printf("%d) sensor: %3.1fC  ",(sensorcounter+1),probe[sensorcounter]->temperature('c'));
        sensorcounter = (++sensorcounter)%devices_found;
        }
        }
        
    if (counter%4==0) {
        lcd.locate(0,2);
        if (wanIP[0]!=0) {
            if (IPshowflag) {
                lcd.printf("IP: %s        ", localIP);
            } else {
                lcd.printf("IP: %s        ", myUrl.c_str());
            }
            IPshowflag = !IPshowflag;
        } else {
            //DO nothing only one ip address is shown
        }
    }

    if (counter%1==0) { //Every sec
        lcd.locate(0,3);
        ctTime = time(NULL);
        ctTime += (clockoffset*3600);
        strftime(buf,sizeof(buf), "%Y/%m/%d %H:%M:%S", localtime(&ctTime));
        lcd.printf("%s", buf);
    }


}

//----------------Update time---------------------
void UpdateTime() {
/*
    NTPClient * ntp = new NTPClient(); //NTP client
    time_t ctTime;
    ctTime = time(NULL);
    printf("Current time is (UTC): %s\n", ctime(&ctTime));
    Host server(IpAddr(), 123, "0.hu.pool.ntp.org");
    ntp->setTime(server);
    ctTime = time(NULL);
    ctTime += (clockoffset*3600); //set jst time
    printf("\nTime is now (UTC): %s\n", ctime(&ctTime)); 
    */
}

//-------------Get file name---------------------
void GetFile(int index, char *st) {
    string stringt = ("");
    char buff[50];
    ctTime = time(NULL);
    ctTime += (clockoffset*3600);
    strftime(buff,sizeof(buff), "%Y/%m/%d %H:%M:%S", localtime(&ctTime));
    stringt += buff[2];
    stringt += buff[3];
    stringt += buff[5];
    stringt += buff[6];
    stringt += buff[8];
    stringt += buff[9];
    sprintf(buff,"%02d",index);
    stringt += buff;
    stringt += ".txt";
    strcpy(st, stringt.c_str());
}

//---------------Load config----------------------
void LoadConfig() {
    FILE    *fs_src;
    char    buffer[ 100 ];
    int linecounter = 0;
    fs_src    = fopen( CONFIG_FILE, "rb" );
    while (fgets(buffer, 100, fs_src)) {
        linecounter++;
        switch (linecounter) {
            case 2 :
                sscanf(buffer,"%d.%d.%d.%d",&ipConfig[0],&ipConfig[1],&ipConfig[2],&ipConfig[3]);
                break;
            case 4 :
                sscanf(buffer,"%d.%d.%d.%d",&maskConfig[0],&maskConfig[1],&maskConfig[2],&maskConfig[3]);
                break;
            case 6 :
                sscanf(buffer,"%d.%d.%d.%d",&gatewayConfig[0],&gatewayConfig[1],&gatewayConfig[2],&gatewayConfig[3]);
                break;
            case 8 :
                sscanf(buffer,"%d.%d.%d.%d",&dnsConfig[0],&dnsConfig[1],&dnsConfig[2],&dnsConfig[3]);
                break;
            case 10:
                if (buffer[0]=='t' | buffer[0]=='T') getIPfromDHCP= true;
                else getIPfromDHCP = false;
                break;
            case 12:
                if (buffer[0]=='t' | buffer[0]=='T') localmode= true;
                else localmode = false;
                break;               
            case 15:
                sscanf(buffer,"%d",&interval);
                break;
            case 17:
                sscanf(buffer,"%d",&clockoffset);
                break;
            case 20:
                myUrl = buffer;
                break;
        }

    }

    fclose( fs_src );
}
//---------------Save config--------------------------
void SaveConfig()
{
printf("SAVING CONFIG\r\n");
FILE *fs_src;
fs_src    = fopen( CONFIG_FILE, "w" );
printf("SAVING CONFIG\r\n");
fprintf(fs_src,"%s\r\n","IP adress");
fprintf(fs_src,"%d.%d.%d.%d\r\n",ipConfig[0],ipConfig[1],ipConfig[2],ipConfig[3]);
fprintf(fs_src,"%s\r\n","Network Mask");
fprintf(fs_src,"%d.%d.%d.%d\r\n",maskConfig[0],maskConfig[1],maskConfig[2],maskConfig[3]);
fprintf(fs_src,"%s\r\n","Gateway");
fprintf(fs_src,"%d.%d.%d.%d\r\n",gatewayConfig[0],gatewayConfig[1],gatewayConfig[2],gatewayConfig[3]);
fprintf(fs_src,"%s\r\n","DNS");
fprintf(fs_src,"%d.%d.%d.%d\r\n",dnsConfig[0],dnsConfig[1],dnsConfig[2],dnsConfig[3]);
fprintf(fs_src,"%s\r\n","Get IP from DHCP (true/false)");
if (getIPfromDHCP)
{
fprintf(fs_src,"True\r\n");
}
else
{
fprintf(fs_src,"False\r\n");
}
fprintf(fs_src,"%s\r\n","Local only mode (true/false)");
if (localmode)
{
fprintf(fs_src,"True\r\n");
}
else
{
fprintf(fs_src,"False\r\n");
}
fprintf(fs_src,"%s\r\n","---------------");
fprintf(fs_src,"%s\r\n","Interval (sec)");
fprintf(fs_src,"%d\r\n",interval);
fprintf(fs_src,"%s\r\n","CET Clock offset (hour)");
fprintf(fs_src,"%d\r\n",clockoffset);
fprintf(fs_src,"%s\r\n","---------------");
fprintf(fs_src,"%s\r\n","My URL");
fprintf(fs_src,"%s\r\n",myUrl.c_str());

fclose( fs_src );
}
//---------------Load status--------------------------
void LoadStatus() {
    FILE    *fs_src;
    char    buffer[ 100 ];
    int linecounter = 0;
    fs_src    = fopen( STATUS_FILE, "rb" );
    while (fgets(buffer, 100, fs_src)) {
        linecounter++;

        switch (linecounter) {
            case 1:
                sscanf(buffer,"%d",&logging);
                break;
            case 2:
                sscanf(buffer,"%s",logfile);
                break;
        }

    }

    fclose( fs_src );
}

//-----------------Save status-------------------------
void SaveStatus() {
    printf("Saving status\r\n");
    FILE    *fs_dest;
    fs_dest    = fopen( STATUS_FILE, "w" );
    fprintf(fs_dest,"%d\r\n%s\r\n",logging,logfile);
    fclose( fs_dest );
    printf("Status saved\r\n");
}

//---------------Log writer-----------------------------
void LogWrite(string stringin) {
    FILE *fp = fopen(LOGGER_FILE, "a+");
    if (fp == NULL) {
        error("Could not open file for write\r\n");
    }
    fprintf(fp,"%s\r\n",stringin.c_str());
    fclose(fp);
}

//---------------Measurement start --------------

void MeasureStart() {

    char file[20];
    char st[50];

    if (logging ==0) {


        logging = 1;
        timerMeasure.start();
        do {
            GetFile(fileindex++,(char*)&st);
            strcpy(file,(char*)&st);

            sprintf(logfile,"%s%s%s",DATA_FOLDER,"/",file);
            PrintRAM();
        } while  (exists(DATA_FOLDER,file));  // while  (sdcardIsFileExist (filepath.c_str())=='t');

        printf ("Saving log file name : %s\r\n",logfile);


        SaveStatus();

        printf ("Printing header into log file: %s\r\n",logfile);

        sdcardWriteFile (logfile,WRITEFILE,"");
        MeasureLogger(1);
    }
    
    
}

//-------------------Measure stop method-----------------------------------
void MeasureStop() {
    if (logging == 1) {
        printf ("Stopping measure.");
        logging = 0;
        SaveStatus();
        timerMeasure.stop();
        printf ("Measure stopped.");
    }

}

/** ----------------------------------------------------------------------
*    sdcardWriteFile
*    Ecrit une trame dans le fichier specifie
*    In     : nom du fichier, mode d'ecriture, donnees a ecrire
*    Out    : true/false
* ---------------------------------------------------------------------*/
char sdcardWriteFile(const char *fileName, char mode, char *data) {

    FILE *fp2;
    switch (mode) {
        case WRITEFILE :
            fp2 = fopen(fileName, "w+");
            break;
        case APPENDFILE :
            fp2 = fopen(fileName, "a+");
            break;
        default:
            fp2 = fopen(fileName, "r");
    }

    if (!fp2) {
        return (false);
    } else {
        fprintf(fp2,data);
        fclose(fp2);
    }

    return (true);
}


//---------- Logger method------------------------------------------------
void MeasureLogger(int force) {

    if (timerMeasure.read() >= (interval-1) | force==1) {
        led2 = 1;
        char buf[50];
        ctTime = time(NULL);
        ctTime += (clockoffset*3600);
        strftime(buf,sizeof(buf), "%Y.%m.%d\t%H:%M:%S", localtime(&ctTime));

        char resp[100] = "";
        strcat(resp,buf);
        char temp[32] ;
        probe[0]->convert_temperature(DS1820::all_devices);
        for (int i=0; i<devices_found; i++) {
            sprintf(temp,"\t%3.1f",(probe[i]->temperature('c')));
            
                 for(int i = 0; i <strlen(temp); i++)
     {
          switch(temp[i])
          {
               case '.':
               temp[i] = ',';
               break;
          }
     }
     
            strcat(resp,temp);
        }
        sprintf( temp , "\r\n");
        strcat(resp,temp);
        sdcardWriteFile (logfile,APPENDFILE,resp);

        led2 = 0;
        timerMeasure.reset();

    }

}

//------------Checks if file exist--------------------------------
bool exists(char * root, char *filename) {
    DIR *d = opendir(root);
    struct dirent *p;
    //printf("\nList of files in the directory %s:\r\n", root);
    bool found = false;
    if ( d != NULL ) {
        while ( !found && (p = readdir(d)) != NULL ) {
            //printf(" - %s\r\n", p->d_name);
            if ( strcmp(p->d_name, filename) == 0 ) {
                found = true;
                printf("File exist\r\n");
            }
        }
    }
    if (!found) {
        printf("File not found\r\n");
    }
    closedir(d);
    return found;
}

//------------------Prints out free ram space----------------------
void PrintRAM()
{
//printf("Available memory (exact bytes) : %d\r\n", AvailableMemory(1));
}
//-----------------Update List-------------------------------------
void UpdateList()
{
    DIR *d = opendir(DATA_FOLDER);
    struct dirent *p;
    char buff[40];
    printf("\nList of files in the directory %s:\r\n", DATA_FOLDER);

    sdcardWriteFile (FILELIST_FILE,WRITEFILE,"");

    FILE *fp2;
    fp2 = fopen(FILELIST_FILE, "a+");

    while ( (p = readdir(d)) != NULL ) {
        printf(" - %s\r\n", p->d_name);
        sprintf(buff,"%s\r\n", p->d_name);
        fprintf(fp2,buff);
    }
fprintf(fp2,"\r\n");
    fclose(fp2);
    closedir(d);
}