#include "mbed.h"
#include "WatchDog.h"


watchdog::watchdog(float s) {
    LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
    uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4 
    LPC_WDT->WDTC = s * (float)clk;         
    LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset        
    feed();    
}

watchdog_ms::watchdog_ms(int ms) {
    LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
    uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4 
    LPC_WDT->WDTC = ((float)ms * (float)clk) /1000;         
    LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset        
    feed();
}

watchdog_us::watchdog_us(int us) {
    LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
    uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4 
    LPC_WDT->WDTC = ((float)us * (float)clk) /1000000;         
    LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset        
    feed();
}

void watchdog::feed() {
    LPC_WDT->WDFEED = 0xAA;
    LPC_WDT->WDFEED = 0x55;
}
void watchdog_ms::feed() {
    LPC_WDT->WDFEED = 0xAA;
    LPC_WDT->WDFEED = 0x55;
}
void watchdog_us::feed() {
    LPC_WDT->WDFEED = 0xAA;
    LPC_WDT->WDFEED = 0x55;
}
