#ifndef WATCHDOG_H
#define WATCHDOG_H

#include "mbed.h"

/** Watchdog timer implementation (in seconds) */
class watchdog {
public: 
    /** Creates Watchdog timer
    * 
    * @param Sets the WDT in seconds
    */
    watchdog(float s);
    
    /** Keep feeding the watchdog in routine
    *
    * xxx.feed(); does the trick
    */
    void feed();
};
/** Watchdog timer implementation (in milliseconds) */
class watchdog_ms {
public: 
    /** Creates Watchdog timer
    * 
    * @param Sets the WDT in milliseconds
    */
    watchdog_ms(int ms);
    /** Keep feeding the watchdog in routine
    *
    * xxx.feed(); does the trick
    */
    void feed();
};
/** Watchdog timer implementation (in microseconds) */
class watchdog_us {
public:
    /** Creates Watchdog timer
    * 
    * @param Sets the WDT in microseconds
    */
    watchdog_us(int us);
    /** Keep feeding the watchdog in routine
    *
    * xxx.feed(); does the trick
    */    
    void feed();
};

#endif