#include "mbed.h"

PwmOut onb_led1(LED1);
PwmOut onb_led2(LED2);
PwmOut onb_led3(LED3);
PwmOut onb_led4(LED4);

#define led_fade 0.10 //The multiplier for one time step of fade

int main(void) {
    //A flag to indicate which direction we should rotate
    bool flag = 0;
    //the states of the outputs
    char outstates = 1;
    
    onb_led1.period_ms(5);
    onb_led2.period_ms(5);
    onb_led3.period_ms(5);
    onb_led4.period_ms(5);
    
    //Infinite loop
    while(1) {
        wait(0.25);
        if (!flag) {
            outstates *= 2;
            if ((outstates>>3)&&1) flag=1;
        } else {
            outstates /=2;
            if (outstates==1) flag=0;
        }
        
        switch(outstates){
            case(1):{
                onb_led1=1.0f;
                onb_led2=led_fade*(onb_led2);
        	    onb_led3=led_fade*(onb_led3);
        	    onb_led4=led_fade*(onb_led4);
                break;
            }  
        	case(2):{
	            onb_led1=led_fade*(onb_led1);
        	    onb_led2=1.0f;
        	    onb_led3=led_fade*(onb_led3);
        	    onb_led4=led_fade*(onb_led4);
        	    break;
        	}
        	case(4):{
        	    onb_led1=led_fade*(onb_led1);
        	    onb_led2=led_fade*(onb_led2);
        	    onb_led3=1.0f;
        	    onb_led4=led_fade*(onb_led4);
        	    break;
        	}
        	case(8):{
        	    onb_led1=led_fade*(onb_led1);
        	    onb_led2=led_fade*(onb_led2);
        	    onb_led3=led_fade*(onb_led3);
        	    onb_led4=1.0f;
        	    break;
        	}
        }
    }
}
        
    