#include "mbed.h"          // MBED LIBRARY
#include "string.h"
#include "DHT.h"

// SETUP (ASSIGN) SERIAL COMMUNICATION PINS ON MBED
Serial pc(USBTX, USBRX);  // PC SERIAL OVER USB PORT ON MBED
Serial HC06(p9, p10);
DHT sensor(p23, DHT11);

DigitalOut Relais1(p17);
DigitalOut Relais2(p18);
DigitalOut Relais3(p16);
DigitalOut Relais4(p20);


#define SBIT_CLKEN     0    /* RTC Clock Enable*/
#define SBIT_CTCRST    1    /* RTC Clock Reset */
#define SBIT_CCALEN    4    /* RTC Calibration counter enable */


int32_t TempsUnix = 0;
int32_t TempsArrosage = 5;// en seconde

uint8_t AlarmHOUR   = 8;   // Alarme hour value
uint8_t AlarmMIN    = 1;   // Alarme min value

bool alarmstate = false;// Determines whether the alarm is set or not
bool ringflag = false;  // Determines if alarm is ringing


Ticker myTicker;






void setclock()
{

    pc.printf("Entrer Temps Unix actuel from https://www.timestampconvert.com/:\r\n");
    pc.scanf("%u", &TempsUnix);//https://www.timestampconvert.com/
    pc.printf("Temps Unix actuel %d:\r\n",TempsUnix);
    set_time(TempsUnix); // Set time to actual time
}



void readHC06()
{

    int a = HC06.getc();
    pc.printf("Le chifre est: %d \n\r",a);

    switch(a) {
        case '1':
            Relais1=0;
            break;

        case '2':
            Relais2=0;
            break;

        case '3':
            Relais3=0;
            break;

        case '4':
            Relais4=0;
            break;
        case 'A':
            Relais1=1;
            break;

        case 'B':
            Relais2=1;
            break;

        case 'C':
            Relais3=1;
            break;

        case 'D':
            Relais4=1;
            break;
        case '9': // A changer pour le rendre normalement ouvert
            Relais1=0;
            Relais2=0;
            Relais3=0;
            Relais4=0;
            break;

        case 'I':
            Relais1=1;
            Relais2=1;
            Relais3=1;
            Relais4=1;
            break;
        // operator doesn't match any case constant (+, -, *, /)
        default:
            printf("Error! operator is not correct");
    }
}
void ResetRelais()
{
    Relais1=1;
    Relais2=1;
    Relais3=1;
    Relais4=1;
}


/******************************************************************
 * Arrosage
 *
 * This function rings while alarm by power pompe
 *****************************************************************/
void alarm_ring()
{
    Relais1=0;//pompe en marche
    ringflag = true;//indicateur arrossage active
    --TempsArrosage; //decremettion temps d'arrosage de 1 secaonde
    if(TempsArrosage == 0 ) {
        Relais1=1; //Arret de la pompe
        myTicker.detach();// blocage des interruptions de la larme
    }


}

/******************************************************************
 * Alarm_check
 *
 * This function compares the alarm time vs the current time. Once
 * alarm time and real time match it begins ringing the alarm.
 * Once the times differ then it turns off the alarm.
 *****************************************************************/
void alarm_check()
{
    if ((LPC_RTC->HOUR == AlarmHOUR) && (LPC_RTC->MIN == AlarmMIN)) {
        if ((alarmstate == true) && (ringflag == false)) {
            myTicker.attach_us(&alarm_ring,1000000.0f); // run every 40us, Could use .attach(&onTick,0.00004) if you prefer.
        }
    } else {


    }
}

int main()
{


    uint16_t year;
    uint8_t hour, min, sec, date, month;
    int error = 0;
    float h = 0.0f, c = 0.0f, f = 0.0f, k = 0.0f, dp = 0.0f, dpf = 0.0f;

    pc.baud(115200);
    HC06.baud(9600);
    ResetRelais();
    pc.printf("Start Programme\n\r");


    /* Disable RTC clock, reset clock, Enable RTC calibration */
    LPC_RTC->CCR = ((1 << SBIT_CTCRST ) | (1 << SBIT_CCALEN));
    LPC_RTC->CALIBRATION = 0x00;
    LPC_RTC->CCR = (1 << SBIT_CLKEN);    /* Enable the clock for RTC */

    //  setclock();

    /* Set Date and Time only once, comment these lines after setting the time and date */
    // Set Date 23th Mai 2019
    LPC_RTC->DOM    = 23;   // Update date value
    LPC_RTC->MONTH  = 05;   // Update month value
    LPC_RTC->YEAR   = 2019; // Update year value

    // Set Time 10:40:25 AM
    LPC_RTC->HOUR   = 8;   // Update hour value
    LPC_RTC->MIN    = 00;   // Update min value
    LPC_RTC->SEC    = 00;   // Update sec value


    //set_time(1558477269); // Set time to Wed, 28 Oct 2009 11:35:37

    alarmstate = true;
    HC06.attach(readHC06);




//      time_t seconds = time(NULL);
//    printf ("Time as seconds since January 1, 1970 = %d\n", seconds);        //https://time.is/Unix_time_now
//    printf ("Time as a basic string = %s", ctime(&seconds));
//    char buffer [32];
//    strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
//    printf ("Time as a custom formatted string = %s", buffer);



    while(1) {

        wait(1.0f);
        /* Read Time */
        hour = LPC_RTC->HOUR;
        min  = LPC_RTC->MIN;
        sec  = LPC_RTC->SEC;

        /* Read Date */
        date  = LPC_RTC->DOM;
        month = LPC_RTC->MONTH;
        year  = LPC_RTC->YEAR;


        pc.printf("Date: %2d/%2d/%4u\n\r",date,month,year);
        pc.printf("Time: %2d:%2d:%2d\n\r",hour,min,sec);

        error = sensor.readData();

        if (0 == error) {
            c   = sensor.ReadTemperature(CELCIUS);
            f   = sensor.ReadTemperature(FARENHEIT);
            k   = sensor.ReadTemperature(KELVIN);
            h   = sensor.ReadHumidity();
            dp  = sensor.CalcdewPoint(c, h);
            dpf = sensor.CalcdewPointFast(c, h);
            printf("Temperature in Kelvin: %4.2f, Celcius: %4.2f, Farenheit %4.2f\n", k, c, f);
            printf("Humidity is %4.2f, Dewpoint: %4.2f, Dewpoint fast: %4.2f\n\r\n\r", h, dp, dpf);


        } else {
            printf("Error: %d\n", error);
        }
        /* Check to see if the alarm should be started/stopped */
        alarm_check();


    }

}
