#include "mbed.h"
#include "USBHostMSD.h"
//#include "gps.h"     // gps def HEADER

// Definitions of states for gpd USART receiver state machine (for receiving packets)
 #define GPS_STATE_WAIT       1
 #define GPS_STATE_DATA       2

Serial pc(USBTX, USBRX);  // PC SERIAL OVER USB PORT ON MBED
Serial gps(p13, p14);    // GPS SERIAL OVER UART PINS 13 & 14
DigitalOut gps_activity(LED4);

USBHostMSD msd("usb");
FILE *fp;
uint8_t gps_State = GPS_STATE_WAIT;

unsigned char gps_data[200];
int data_gps_lenth;

unsigned char c;
char Exit = 0;
int gps_flag =0;


void attgps() {

    if (gps.readable()) {

        //*gps_activity =!gps_activity;
        switch ( gps_State ) {  // In this state, the USART is waiting to see the sequence of bytes that signals a new incoming packet from gps.
                static unsigned char data_counter=0;
            case GPS_STATE_WAIT:
                c = gps.getc();
                if ( data_counter == 0 ) {    // Waiting on '$' character
                    if ( c == '$' ) {
                        gps_data[data_counter]= c;
                        data_counter++;
                    } else {
                        data_counter = 0;
                    }
                } else if ( data_counter == 1 ) {   // Waiting on 'G' character
                    if (c == 'G' ) {
                        gps_data[data_counter]= c;
                        data_counter++;
                    } else {
                        data_counter = 0;
                    }
                } else if ( data_counter == 2 ) {   // Waiting on 'P' character
                    if ( c == 'P' ) {
                        // The full '$GP' sequence was received.  Reset data_counter (it will be used again
                        // later) and transition to the next state.

                        gps_data[data_counter] = c;
                        gps_State = GPS_STATE_DATA;
                        data_counter++;

                    } else {
                        data_counter = 0;
                    }
                }
                break;

                // USART in the DATA state.  In this state, the USART expects to receive data.
            case GPS_STATE_DATA:
                c = gps.getc();
                if (c != (0x0D)) {
                    gps_data[data_counter] = c;
                    data_counter++;
                    break;
                }
                data_gps_lenth = data_counter;
                data_counter=0;
                gps_State = GPS_STATE_WAIT;
                gps_flag = 1;
                break;

        }
    }
}
void comandExit () {
    Exit = pc.getc();
    //pc.printf("Exit");
}

int main() {
    FILE *fp = fopen("/fs/Enregistrement.txt", "w");
    if (fp == NULL) {
        error("Could not open file for write  MSC\n");
    }
    pc.baud(38400);
    gps.baud(38400);
    pc.attach(comandExit);
    gps.attach(attgps);
    
    while (Exit!='$')  {
        if (gps_flag == 1) {
            for (int i=0; i<data_gps_lenth+1; i++) {
                pc.putc(gps_data[i]);
             
            }
            pc.printf("\r\n");
            gps_flag = 0;
        }
        gps_activity =!gps_activity;
        
    }
}

