#include "mbed.h"
#include "chr.h"
#include "SDFileSystem.h"
#include "BMP085.h"
#include "MSCFileSystem.h"

SDFileSystem sd(p5, p6, p7, p8, "sd"); // mosi, miso, sclk, cs, name
BMP085 bmp085(p28, p27);
Serial imu(p13, p14);
Serial pc(USBTX, USBRX);

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

InterruptIn event_EOC(p23);

//DigitalIn BPM085_EOC (p23); 
DigitalOut activate(p22);
DigitalIn enable(p21);


MSCFileSystem msc("msc");
 
char data[MAX_BYTES];
int _state = WAIT_s;
char c;
int d;
unsigned char pt;
unsigned int n;
int yaw;
int pitch;
int roll;
unsigned short int tag_imu;

FILE *fp,*usbp;
Timer tt,tmesure;
Ticker periode1;
void sendPacket(unsigned char pt, unsigned int n,char data[])
{
    //unsigned int checksum;    
    int checksum = HEADER_CHECKSUM +pt+n; 
    if (imu.writeable()) 
        {
            imu.printf("snp");
            imu.putc(pt);
            imu.putc(n);
            
            for (int i=0; i < n; i++) 
                {
                    imu.putc(data[i]);
                    checksum += data[i];
                }
            imu.putc((char) (checksum >> 8));   // MSByte
            imu.putc((char) (checksum & 0x0FF)); // LSByte
        }
      
}


void Int_DataLogger ()
{
    myled1 = 1;
    myled2 = 1;
    myled3 = 1;
    myled4 = 1;
    wait_ms(300);
    pc.baud(115200);
    myled1 = 0;
    imu.baud(115200);
    
    myled2 = 0;
    pc.printf("Hello!\n CHR-6dm Test Program \r/");
    
    //event_EOC.rise(&trigger);
    //Enables "Broadcast Mode." the AHRS automatically transmits sensor data every Ts
       
    data[0]= 0xA4;   //= 100Hz
    sendPacket(SET_BROADCAST_MODE, 1,data );
    myled3 = 0; 
    wait_ms(100);
       
    //Specifies which channel data should be transmitted over the UART.
    data[0]= 0xFF; //{yaw, pitch, roll, yaw_rate, pitch_rate, roll_rate,mag_x, mag_y}
    data[1]= 0xFF; //{mag_z, gyro_x, gyro_y,gyro_z, accel_x, accel_y,accel_z,0 }
    sendPacket(SET_ACTIVE_CHANNELS,2,data );
    myled3 = 1;
    myled4 = 0;
    wait_ms(100); 
    
       
}

void attimu()
{
    if (imu.readable()) 
    {
        c = imu.getc();
        switch (_state)
        {
            case WAIT_s :
                if (c == 's') _state = WAIT_n;
                break;
            case WAIT_n :
                _state = (c == 'n') ? WAIT_p : WAIT_s;
                break;
            case WAIT_p :
                _state = (c == 'p') ? PT : WAIT_p;
                break;
            case PT :
                pt = c;
                _state = N;
                break;
            case N :
                n = ((unsigned int) c) - 2;
                d = 0;
                _state = (n < MAX_BYTES) ? RX_PACKET : WAIT_s;
                break;
            case RX_PACKET :
                data[d++] = c;
                if (d >= n || d >= MAX_BYTES) _state = PROCESS_PACKET;
                break;
            case  PROCESS_PACKET :
                switch (pt)
                {
                    // SENSOR_DATA 
                    case PT_SENSOR_DATA :
                        tag_imu=1;
                        break;
                    case PT_COMMAND_COMPLETE :
                        pc.printf("Command Complete\n");
                        break;
                    case PT_COMMAND_FAILED :
                        pc.printf("Command Failed\n");
                        break;
                    case PT_BAD_CHECKSUM :
                        pc.printf("Bad Checksum\n");
                        break;
                    case PT_BAD_DATA_LENGTH :
                        pc.printf("Bad Data Length\n");
                        break;
                    case PT_UNRECOGNIZED_PACKET :
                        pc.printf("Unrecognized Packet\n");
                        break;
                    case PT_BUFFER_OVERFLOW :
                        pc.printf("Buffer Overflow\n");
                        break;            
                     default :
                        break;
                }
                _state = WAIT_s;
                    break;
                default :
                    _state = WAIT_s;
                    break;
        }         
    }   
}

void tick1()
{
      bmp085.update();
}

int main() {
   
    imu.attach(attimu);
    Int_DataLogger ();
    activate=1;  
    periode1.attach_us(tick1,10000); 
    
    //event_EOC.rise(&trigger);
    
    /*    FILE *fp = fopen("/sd/sdtest.txt", "w");
    if (fp == NULL) 
    {
      error("Could not open file for write SD\n");
    }*/
   
    
    
    FILE *usbp = fopen("/msc/sdtest.txt", "w");
    if (usbp == NULL) 
    {
        error("Could not open file for write  MSC\n");
    }
    
        
    tmesure.start();
    tt.start();
    while (enable) 
    {  
         if(tt.read_us()>(unsigned long)50000)
         {
             tt.stop();
             tt.reset();
       
             if(tag_imu==1)
                {
                    fprintf(usbp,"IMU %u %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d\n",tmesure.read_us(),(int16_t)data[0]<<8|data[1],(int16_t)data[2]<<8|data[3],(int16_t)data[4]<<8|data[5],(int16_t)data[6]<<8|data[7],(int16_t)data[8]<<8|data[9],(int16_t)data[10]<<8|data[11],(int16_t)data[12]<<8|data[13],(int16_t)data[14]<<8|data[15],(int16_t)data[16]<<8|data[17],(int16_t)data[18]<<8|data[19],(int16_t)data[20]<<8|data[21],(int16_t)data[22]<<8|data[23],(int16_t)data[24]<<8|data[25],(int16_t)data[26]<<8|data[27],(int16_t)data[28]<<8|data[29]);
                    tag_imu=0;
                    if(bmp085.ok==1)
                        {
                            fprintf(usbp,"PRT %u %6.2f %6.2f \r", tmesure.read_us(),bmp085.get_pressure(), bmp085.get_temperature());
                            bmp085.ok=0;
                        }
                }
            tt.start();
         }  
    }
    
    // fclose(fp);
    fclose(usbp);
    periode1.detach();
    pc.printf("fin enregistrement");

}