#include "mbed.h"


// Null packet

     #define  NO_DATA = 0x00;
     #define  FAILED_CHECKSUM = 0x01;


     int packet[100];
     int packet_length = 0;

// Tx packet types (responses) 

   
     const int  SET_ACTIVE_CHANNELS       =  0x80;
     const int  SET_SILENT_MODE           =  0x81;
     const int  SET_BROADCAST_MODE        =  0x82;
     const int  SET_GYRO_BIAS             =  0x83;
     const int  SET_ACCEL_BIAS            =  0x84;
     const int  SET_ACCEL_REF_VECTOR      =  0x85;
     const int  AUTO_SET_ACCEL_REF        =  0x86;
     const int  ZERO_RATE_GYROS           =  0x87;
     const int  SELF_TEST                 =  0x88;
     const int  SET_START_CAL             =  0x89;
     const int  SET_PROCESS_COVARIANCE    =  0x8A;
     const int  SET_MAG_COVARIANCE        =  0x8B;
     const int  SET_ACCEL_COVARIANCE      =  0x8C;
     const int  SET_EKF_CONFIG            =  0x8D;
     const int  SET_GYRO_ALIGNMENT        =  0x8E;
     const int  SET_ACCEL_ALIGNMENT       =  0x8F;
     const int  SET_MAG_REF_VECTOR        =  0x90;
     const int  AUTO_SET_MAG_REF          =  0x91;
     const int  SET_MAG_CAL               =  0x92;
     const int  SET_MAG_BIAS              =  0x93;
     const int  SET_GYRO_SCALE            =  0x94;
     const int  EKF_RESET                 =  0x95;
     const int  RESET_TO_FACTORY          =  0x96;
     const int  WRITE_TO_FLASH            =  0xA0;
     const int  GET_DATA                  =  0x01;
     const int  GET_ACTIVE_CHANNELS       =  0x02;
     const int  GET_BROADCAST_MODE        =  0x03;
     const int  GET_ACCEL_BIAS            =  0x04;
     const int  GET_ACCEL_REF_VECTOR      =  0x05;
     const int  GET_GYRO_BIAS             =  0x06;
     const int  GET_GYRO_SCALE            =  0x07;
     const int  GET_START_CAL             =  0x08;
     const int  GET_EKF_CONFIG            =  0x09;
     const int  GET_ACCEL_COVARIANCE      =  0x0A;
     const int  GET_MAG_COVARIANCE        =  0x0B;
     const int  GET_PROCESS_COVARIANCE    =  0x0C;
     const int  GET_STATE_COVARIANCE      =  0x0D;
     const int  GET_GYRO_ALIGNMENT        =  0x0E;
     const int  GET_ACCEL_ALIGNMENT       =  0x0F;
     const int  GET_MAG_REF_VECTOR        =  0x10;
     const int  GET_MAG_CAL               =  0x11;
     const int  GET_MAG_BIAS              =  0x12;

 // Board status and data packets
 #define PT_COMMAND_COMPLETE             0xB0
#define PT_COMMAND_FAILED               0xB1
#define PT_BAD_CHECKSUM                 0xB2
#define PT_BAD_DATA_LENGTH              0xB3
#define PT_UNRECOGNIZED_PACKET          0xB4  
#define PT_BUFFER_OVERFLOW              0xB5
#define PT_STATUS_REPORT                0xB6
#define PT_SENSOR_DATA                  0xB7
#define PT_GYRO_BIAS_REPORT             0xB8
#define PT_GYRO_SCALE_REPORT            0xB9
#define PT_START_CAL_REPORT             0xBA
#define PT_ACCEL_BIAS_REPORT            0xBB
#define PT_ACCEL_REF_VECTOR_REPORT      0xBC
#define PT_ACTIVE_CHANNEL_REPORT        0xBD
#define PT_ACCEL_COVARIANCE_REPORT      0xBE
#define PT_MAG_COVARIANCE_REPORT        0xBF
#define PT_PROCESS_COVARIANCE_REPORT    0xC0
#define PT_STATE_COVARIANCE_REPORT      0xC1
#define PT_EKF_CONFIG_REPORT            0xC2
#define PT_GYRO_ALIGNMENT_REPORT        0xC3
#define PT_ACCEL_ALIGNMENT_REPORT       0xC4
#define PT_MAG_REF_VECTOR_REPORT        0xC5
#define PT_MAG_CAL_REPORT               0xC6
#define PT_MAG_BIAS_REPORT              0xC7
#define PT_BROADCAST_MODE_REPORT        0xC8


     /* D1 */
#define YAW_FLAG                0x80
#define PITCH_FLAG              0x40
#define ROLL_FLAG               0x20
#define YAW_RATE_FLAG           0x10
#define PITCH_RATE_FLAG         0x08
#define ROLL_RATE_FLAG          0x04
#define MX_FLAG                 0x02
#define MY_FLAG                 0x01
/* D2 */
#define MZ_FLAG                 0x80
#define GX_FLAG                 0x40
#define GY_FLAG                 0x20
#define GZ_FLAG                 0x10
#define AX_FLAG                 0x08
#define AY_FLAG                 0x04
#define AZ_FLAG                 0x02
#define ZERO_FLAG               0x01


    /* Scale factors
     const double SCALE_YAW        = 0.0109863; // &#65533;/LSB
     const double SCALE_PITCH      = 0.0109863;
     const double SCALE_ROLL       = 0.0109863;
     const double SCALE_YAW_RATE   = 0.0137329; // &#65533;/s/LSB
     const double SCALE_PITCH_RATE = 0.0137329;
     const double SCALE_ROLL_RATE  = 0.0137329;
     const double SCALE_MAG_X      = 0.061035; // mGauss/LSB
     const double SCALE_MAG_Y      = 0.061035;
     const double SCALE_MAG_Z      = 0.061035;
     const double SCALE_GYRO_X     = 0.01812; // &#65533;/s/LSB
     const double SCALE_GYRO_Y     = 0.01812;
     const double SCALE_GYRO_Z     = 0.01812;
     const double SCALE_ACCEL_X    = 0.106812; // mg/LSB
     const double SCALE_ACCEL_Y    = 0.106812;
     const double SCALE_ACCEL_Z    = 0.106812;*/

    const char PACKET_HEADER[] = {'s','n','p'};
    const int HEADER_CHECKSUM = 's'+'n'+'p';
   




#define MAX_BYTES 32
enum _states { WAIT_s, WAIT_n, WAIT_p,PT, N, RX_PACKET, PROCESS_PACKET };

