#ifndef BMP085_H
#define BMP085_H

#include "mbed.h"

/**
 * @brief over sampling setting
 */
enum BMP085_oss {
    BMP085_oss1 = 0, ///< ultra low power (1 time)
    BMP085_oss2 = 1, ///< standard (2 times)
    BMP085_oss4 = 2, ///< high resolution (4 times)
    BMP085_oss8 = 3  ///< ultra high resolution (8 times)
};

/**
 * @brief BMP085 class
 */
class BMP085 : public Base {
public:
    BMP085(PinName p_sda, PinName p_scl, BMP085_oss p_oss = BMP085_oss1);
    BMP085(I2C& p_i2c, BMP085_oss p_oss = BMP085_oss1);

    float get_temperature();
    float get_pressure();
    float get_altitude();
    void update();
    unsigned char ok;

protected:
    void init(BMP085_oss);
    unsigned short twi_readshort (int, int);
    unsigned long twi_readlong (int, int);
    void twi_writechar (int, int, int);

    I2C i2c;
    float temperature;
    float pressure;
    float altitude;

private:

    short ac1, ac2, ac3, b1, b2, mb, mc, md, oss;
    unsigned short ac4, ac5, ac6;
};

#endif
