#include "pah_comm.h"

#include "pah_util.h"


/*============================================================================
STATIC VARIABLE DEFINITIONS
============================================================================*/
static bool _has_drv_comm = false;
static pah_drv_comm_s   _drv_comm;


/*============================================================================
PUBLIC FUNCTION DEFINITIONS
============================================================================*/
void pah_comm_set_drv_comm(const pah_drv_comm_s *drv_comm)
{
    memcpy(&_drv_comm, drv_comm, sizeof(*drv_comm));
    _has_drv_comm = true;
}

bool pah_comm_write(uint8_t addr, uint8_t data)
{
    if (!_has_drv_comm)
        return false;

    if (_drv_comm.type == pah_drv_comm_spi)
        PAH_CLEAR_BIT(addr, 7); //write, bit7 = 0
    
    return PAH_SUCCEEDED(_drv_comm.write(&_drv_comm, addr, data));
}

bool pah_comm_read(uint8_t addr, uint8_t *data)
{
    if (!_has_drv_comm)
        return false;

    if (_drv_comm.type == pah_drv_comm_spi)
        PAH_SET_BIT(addr, 7); //read, bit7 = 1

    return PAH_SUCCEEDED(_drv_comm.read(&_drv_comm, addr, data));
}

bool pah_comm_burst_read(uint8_t addr, uint8_t *data, uint16_t num)
{
    if (!_has_drv_comm)
        return false;

    if (_drv_comm.type == pah_drv_comm_spi)
        PAH_SET_BIT(addr, 7); //read, bit7 = 1

    return PAH_SUCCEEDED(_drv_comm.burst_read(&_drv_comm, addr, data, num));
}

pah_comm_bus_e pah_comm_get_bus_type(void)
{
    if (_drv_comm.type == pah_drv_comm_spi)
        return pah_comm_bus_spi;
    return pah_comm_bus_i2c;
}
