#pragma once


#include "pah_ret.h"
#include <stdint.h>


struct pah_drv_comm_s;

typedef enum {
    pah_drv_comm_i2c,
    pah_drv_comm_spi,
} pah_drv_comm_type_e;


typedef struct pah_drv_comm_s {

    void                    *user_data;
    pah_drv_comm_type_e     type;
    uint32_t                max_length;

    pah_ret (*write)(struct pah_drv_comm_s *comm, uint8_t addr, uint8_t data);
    pah_ret (*write_delay)(struct pah_drv_comm_s *comm, uint8_t addr, uint8_t data, uint32_t delay_ms);
    pah_ret (*read)(struct pah_drv_comm_s *comm, uint8_t addr, uint8_t *data);
    pah_ret (*burst_read)(struct pah_drv_comm_s *comm, uint8_t addr, uint8_t *data, uint32_t rx_size);

} pah_drv_comm_s;


