#ifndef __pixart_pah8011_h__
#define __pixart_pah8011_h__


#include <mbed.h>

#include <cstdint>


namespace pixart {


    class pah8011 {
    public:
        typedef void (*DEBUG_PRINT_HANDLE)(const char *fmt, ...);
        
        struct task_result {
            // ppg
            int32_t     *data;
            uint32_t    num_per_ch;
            uint32_t    ch_num;
            
            // touch
            bool        is_touched;
        };
    
    public:
        pah8011(I2C &i2c, uint8_t slave_id = 0x15);
        pah8011(SPI &spi, DigitalOut &cs);
        ~pah8011();
        
        void    enable_debug_print(DEBUG_PRINT_HANDLE handler);
        
        bool    init();
        
        // operations
        bool    enable_ppg();
        bool    disable_ppg();
        bool    enable_touch();
        bool    disable_touch();
        
        // tasking
        bool    task();
        bool    get_result(task_result &result);
        
        // access
        I2C*        get_i2c() const;
        uint8_t     get_i2c_slave_id() const;
        SPI*        get_spi() const;
        DigitalOut* get_spi_cs() const;
    
    private:
        pah8011(const pah8011&); // = delete;
        pah8011& operator=(const pah8011&); // = delete;
    
        bool    select_mode();

    private:
        // i2c
        I2C         *m_i2c;
        uint8_t     m_i2c_slave_id;
        
        // spi
        SPI         *m_spi;
        DigitalOut  *m_spi_cs;
        
        // state
        bool        m_is_ppg_enabled;
        bool        m_is_touch_enabled;

    };
    
    
}


#endif // header guard
