/**
 * @file pah_ret.h
 *
 * Copyright (c) 2016-2017 PixArt Imaging Inc.
 * All Rights Reserved.
 * Confidential and Proprietary - PixArt Imaging Inc.
 **/
#ifndef __pah_ret_h__
#define __pah_ret_h__


typedef enum {

    PAH_RET_SUCCESS = 0,            // Success

    PAH_RET_FAILED,                 // Unknown error, generally there exists bug in this driver

    PAH_RET_PLAT_FAILED,            // Platform API failed
    PAH_RET_VERIFY_FAILED,          // Verify device failed

    PAH_RET_NOT_IMPLEMENTED,        // This API is not supported or is not implemented

    PAH_RET_INVALID_ARGUMENT,       // Invalid argument to API
    PAH_RET_INVALID_OPERATION,      // This operation is not available at this time

    PAH_RET_FIFO_CKS_FAILED,        // Failed to compare check sum with fifo data
    PAH_RET_FIFO_OVERFLOW,          // Fifo in device is overflow

} pah_ret;


#define PAH_SUCCEEDED(ret)              (ret == PAH_RET_SUCCESS)
#define PAH_FAILED(ret)                 (!PAH_SUCCEEDED(ret))


#define PAH_CHECK_RET(ret) \
    if (PAH_FAILED(ret)) { \
        return ret; \
    }

#define PAH_CHECK_NULL(p) \
    if (!p) { \
        return PAH_RET_INVALID_ARGUMENT; \
    }


#endif  // header guard

