/**
 * @file pah_util.h
 *
 * Copyright (c) 2016-2017 PixArt Imaging Inc.
 * All Rights Reserved.
 * Confidential and Proprietary - PixArt Imaging Inc.
 **/
#ifndef __pah_util_h__
#define __pah_util_h__


#include <stdint.h>


#define PAH_ARRAY_SIZE(arr)         (sizeof(arr) / sizeof(arr[0]))

#define PAH_SET_BIT(var,pos)        do { ((var) |= (1 << (pos))); } while(0)
#define PAH_CLEAR_BIT(var,pos)      do { ((var) &= ~(1 << (pos))); } while(0)
#define PAH_CHECK_BIT(var,pos)      (((var) >> (pos)) & 1)

#define PAH_UINT64_HIGH(var)  ((uint32_t)(var >> 32))
#define PAH_UINT64_LOW(var)   ((uint32_t)(var & UINT32_MAX))


#endif  // header guard

