#ifndef __pixart_heart_rate_demo_h__
#define __pixart_heart_rate_demo_h__


#include <mbed.h>
#include <stdbool.h>
#include <stdint.h>


namespace pixart {
    

    class heart_rate_demo {
    public:
        heart_rate_demo(I2C &i2c, InterruptIn &interrupt, Serial &serial);
    
        void run();
    
    private:
        static void error_handler();
        static void debug_print(const char *fmt, ...);
        static uint64_t time_to_millisec(uint64_t time);
        
    private:
        void pah8011_interrupt_handle(void);
    
        I2C                 &m_i2c;
        InterruptIn         &m_interrupt;
        
        volatile bool       m_has_pah8011_interrupt;
        volatile uint64_t   m_pah8011_interrupt_timestamp;
    
    };
    

}


#endif // header guard
