#include "system_clock.h"

#include <mbed.h>


static Ticker               g_ticker;
static volatile uint64_t    g_sys_tick = 0;


static void system_tick_handle(void)
{
    g_sys_tick++;
}

void system_clock_init()
{
    g_sys_tick = 0;
    
    g_ticker.attach(system_tick_handle, 0.001f);
}

uint64_t system_clock_get_tick()
{
    return g_sys_tick;
}

uint64_t system_clock_time_to_milliseconds(uint64_t time)
{
    return time;
}
