#ifndef MICROSHELL_CLASS_H
#define MICROSHELL_CLASS_H

#include "mbed.h"

class MicroShell
{
public:
    MicroShell(PinName tx, PinName rx, int baud = 9600);

    void putc(int c);
    void puts(const char *s);
    int getc();
    char *gets(char *s, int size);
    int printf(const char* format, ...);
    int scanf( const char* format, ...);
    int vprintf(const char* format, std::va_list args);
    int vscanf( const char* format, std::va_list args);
};

#endif